/*
 * Decompiled with CFR 0.152.
 */
package fathom.rest.security;

import com.google.inject.Provider;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import fathom.Module;
import fathom.rest.controller.Controller;
import fathom.rest.security.BasicAuthenticationHandler;
import fathom.rest.security.FormAuthenticationHandler;
import fathom.rest.security.aop.ControllerInterceptor;
import fathom.rest.security.aop.RequireAdministrator;
import fathom.rest.security.aop.RequireAdministratorInterceptor;
import fathom.rest.security.aop.RequireAuthenticated;
import fathom.rest.security.aop.RequireAuthenticatedInterceptor;
import fathom.rest.security.aop.RequirePermission;
import fathom.rest.security.aop.RequirePermissionInterceptor;
import fathom.rest.security.aop.RequirePermissions;
import fathom.rest.security.aop.RequirePermissionsInterceptor;
import fathom.rest.security.aop.RequireRole;
import fathom.rest.security.aop.RequireRoleInterceptor;
import fathom.rest.security.aop.RequireRoles;
import fathom.rest.security.aop.RequireRolesInterceptor;
import fathom.rest.security.aop.RequireToken;
import fathom.rest.security.aop.RequireTokenInterceptor;
import fathom.security.SecurityManager;
import org.aopalliance.intercept.MethodInterceptor;

public class SecurityModule
extends Module {
    protected void setup() {
        this.bind(BasicAuthenticationHandler.class);
        this.bind(FormAuthenticationHandler.class);
        Matcher controllers = Matchers.subclassesOf(Controller.class);
        Matcher notControllers = Matchers.not((Matcher)controllers);
        ControllerInterceptor controllerInterceptor = new ControllerInterceptor((Provider<SecurityManager>)this.getProvider(SecurityManager.class));
        this.bindInterceptor(controllers, Matchers.any(), new MethodInterceptor[]{controllerInterceptor});
        RequireTokenInterceptor tokenInterceptor = new RequireTokenInterceptor((Provider<SecurityManager>)this.getProvider(SecurityManager.class));
        this.bindInterceptor(notControllers, Matchers.annotatedWith(RequireToken.class), new MethodInterceptor[]{tokenInterceptor});
        RequireAuthenticatedInterceptor authenticatedInterceptor = new RequireAuthenticatedInterceptor();
        this.bindInterceptor(notControllers, Matchers.annotatedWith(RequireAuthenticated.class), new MethodInterceptor[]{authenticatedInterceptor});
        RequireAdministratorInterceptor administratorInterceptor = new RequireAdministratorInterceptor();
        this.bindInterceptor(notControllers, Matchers.annotatedWith(RequireAdministrator.class), new MethodInterceptor[]{administratorInterceptor});
        RequireRoleInterceptor roleInterceptor = new RequireRoleInterceptor();
        this.bindInterceptor(notControllers, Matchers.annotatedWith(RequireRole.class), new MethodInterceptor[]{roleInterceptor});
        RequirePermissionInterceptor permissionInterceptor = new RequirePermissionInterceptor();
        this.bindInterceptor(notControllers, Matchers.annotatedWith(RequirePermission.class), new MethodInterceptor[]{permissionInterceptor});
        RequireRolesInterceptor rolesInterceptor = new RequireRolesInterceptor();
        this.bindInterceptor(notControllers, Matchers.annotatedWith(RequireRoles.class), new MethodInterceptor[]{rolesInterceptor});
        RequirePermissionsInterceptor permissionsInterceptor = new RequirePermissionsInterceptor();
        this.bindInterceptor(notControllers, Matchers.annotatedWith(RequirePermissions.class), new MethodInterceptor[]{permissionsInterceptor});
    }
}

