/*
 * Decompiled with CFR 0.152.
 */
package fathom.rest.security;

import fathom.authc.AuthenticationToken;
import fathom.authc.StandardCredentials;
import fathom.realm.Account;
import fathom.rest.Context;
import fathom.security.SecurityManager;

public abstract class StandardCredentialsHandler {
    protected final SecurityManager securityManager;

    protected StandardCredentialsHandler(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    protected final boolean isAuthenticated(Context context) {
        Account account = (Account)context.getSession("account");
        if (account == null) {
            account = (Account)context.getLocal("account");
        }
        return account != null && account.isAuthenticated();
    }

    protected Account authenticate(String username, String password) {
        StandardCredentials authenticationToken = new StandardCredentials(username, password);
        Account account = this.securityManager.authenticate((AuthenticationToken)authenticationToken);
        return account;
    }
}

