/*
 * Decompiled with CFR 0.152.
 */
package fathom.rest.security.aop;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import fathom.authc.AuthenticationToken;
import fathom.authc.TokenCredentials;
import fathom.authz.AuthorizationException;
import fathom.realm.Account;
import fathom.rest.Context;
import fathom.rest.security.aop.RequireAdministrator;
import fathom.rest.security.aop.RequireAuthenticated;
import fathom.rest.security.aop.RequireGuest;
import fathom.rest.security.aop.RequireToken;
import fathom.rest.security.aop.SecurityInterceptor;
import fathom.rest.security.aop.SecurityUtil;
import fathom.security.SecurityManager;
import fathom.utils.ClassUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.route.RouteDispatcher;

public class ControllerInterceptor
extends SecurityInterceptor {
    private final Logger log = LoggerFactory.getLogger(ControllerInterceptor.class);
    private final Provider<SecurityManager> securityManager;

    @Inject
    public ControllerInterceptor(Provider<SecurityManager> securityManager) {
        this.securityManager = securityManager;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Account account = this.checkRequireToken(method);
        this.checkRequirePermissions(account, method);
        this.checkRequireRoles(account, method);
        this.checkRequireAdministrator(account, method);
        this.checkRequireAuthenticated(account, method);
        this.checkRequireGuest(account, method);
        return invocation.proceed();
    }

    protected Account checkRequireToken(Method method) {
        Account account = this.getAccount();
        RequireToken requireToken = (RequireToken)ClassUtil.getAnnotation((Method)method, RequireToken.class);
        if (requireToken != null) {
            String tokenName = requireToken.value();
            Context context = (Context)RouteDispatcher.getRouteContext();
            String token = Strings.emptyToNull((String)context.getRequest().getHeader(tokenName));
            if (Strings.isNullOrEmpty((String)(token = (String)Optional.fromNullable((Object)token).or((Object)context.getParameter(tokenName).toString(""))))) {
                throw new AuthorizationException("Missing '{}' token", new Object[]{tokenName});
            }
            if (account.isGuest()) {
                TokenCredentials credentials = new TokenCredentials(token);
                account = ((SecurityManager)this.securityManager.get()).authenticate((AuthenticationToken)credentials);
                if (account == null) {
                    throw new AuthorizationException("Invalid '{}' value '{}'", new Object[]{tokenName, token});
                }
                context.setLocal("account", (Object)account);
                this.log.debug("'{}' account authenticated by token '{}'", (Object)account.getUsername(), (Object)token);
            } else {
                account.checkToken(token);
            }
        }
        return account;
    }

    protected void checkRequireRoles(Account account, Method method) {
        Collection<String> roles = SecurityUtil.collectRoles(method);
        if (!roles.isEmpty()) {
            account.checkRoles(roles);
        }
    }

    protected void checkRequirePermissions(Account account, Method method) {
        Collection<String> permissions = SecurityUtil.collectPermissions(method);
        if (!permissions.isEmpty()) {
            account.checkPermissions(permissions);
        }
    }

    protected void checkRequireAdministrator(Account account, Method method) {
        RequireAdministrator annotation = (RequireAdministrator)ClassUtil.getAnnotation((Method)method, RequireAdministrator.class);
        if (annotation != null) {
            account.checkAdministrator();
        }
    }

    protected void checkRequireAuthenticated(Account account, Method method) {
        RequireAuthenticated annotation = (RequireAuthenticated)ClassUtil.getAnnotation((Method)method, RequireAuthenticated.class);
        if (annotation != null) {
            account.checkAuthenticated();
        }
    }

    protected void checkRequireGuest(Account account, Method method) {
        RequireGuest annotation = (RequireGuest)ClassUtil.getAnnotation((Method)method, RequireGuest.class);
        if (annotation != null) {
            account.checkGuest();
        }
    }
}

