/*
 * Decompiled with CFR 0.152.
 */
package fathom.rest.security.aop;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import fathom.authc.AuthenticationToken;
import fathom.authc.TokenCredentials;
import fathom.authz.AuthorizationException;
import fathom.realm.Account;
import fathom.rest.Context;
import fathom.rest.security.aop.RequireToken;
import fathom.rest.security.aop.SecurityInterceptor;
import fathom.security.SecurityManager;
import fathom.utils.ClassUtil;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.route.RouteDispatcher;

public class RequireTokenInterceptor
extends SecurityInterceptor {
    private final Logger log = LoggerFactory.getLogger(RequireTokenInterceptor.class);
    private final Provider<SecurityManager> securityManager;

    @Inject
    public RequireTokenInterceptor(Provider<SecurityManager> securityManager) {
        this.securityManager = securityManager;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        RequireToken requireToken = (RequireToken)ClassUtil.getAnnotation((Method)invocation.getMethod(), RequireToken.class);
        String tokenName = requireToken.value();
        Context context = (Context)RouteDispatcher.getRouteContext();
        String token = Strings.emptyToNull((String)context.getRequest().getHeader(tokenName));
        if (Strings.isNullOrEmpty((String)(token = (String)Optional.fromNullable((Object)token).or((Object)context.getParameter(tokenName).toString(""))))) {
            throw new AuthorizationException("Missing '{}' token", new Object[]{tokenName});
        }
        Account account = this.getAccount();
        if (account.isGuest()) {
            TokenCredentials credentials = new TokenCredentials(token);
            account = ((SecurityManager)this.securityManager.get()).authenticate((AuthenticationToken)credentials);
            if (account == null) {
                throw new AuthorizationException("Invalid '{}' value '{}'", new Object[]{tokenName, token});
            }
            context.setLocal("account", (Object)account);
            this.log.debug("'{}' account authenticated by token '{}'", (Object)account.getUsername(), (Object)token);
        } else {
            account.checkToken(token);
        }
        return invocation.proceed();
    }
}

