/*
 * Decompiled with CFR 0.152.
 */
package fathom.rest.security.aop;

import fathom.rest.security.aop.RequirePermission;
import fathom.rest.security.aop.RequirePermissions;
import fathom.rest.security.aop.RequireRole;
import fathom.rest.security.aop.RequireRoles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SecurityUtil {
    public static Collection<String> collectPermissions(Method method) {
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.addAll(SecurityUtil.collectPermissions(method.getAnnotation(RequirePermissions.class)));
        if (method.isAnnotationPresent(RequirePermission.class)) {
            permissions.add(method.getAnnotation(RequirePermission.class).value());
        }
        permissions.addAll(SecurityUtil.collectPermissions(method.getDeclaringClass().getAnnotation(RequirePermissions.class)));
        if (method.getDeclaringClass().isAnnotationPresent(RequirePermission.class)) {
            permissions.add(method.getDeclaringClass().getAnnotation(RequirePermission.class).value());
        }
        return permissions;
    }

    private static Collection<String> collectPermissions(RequirePermissions requirePermissions) {
        if (requirePermissions == null) {
            return Collections.emptyList();
        }
        ArrayList<String> permissions = new ArrayList<String>();
        for (RequirePermission permission : requirePermissions.value()) {
            permissions.add(permission.value());
        }
        return permissions;
    }

    public static Collection<String> collectRoles(Method method) {
        ArrayList<String> roles = new ArrayList<String>();
        roles.addAll(SecurityUtil.collectRoles(method.getAnnotation(RequireRoles.class)));
        if (method.isAnnotationPresent(RequireRole.class)) {
            roles.add(method.getAnnotation(RequireRole.class).value());
        }
        roles.addAll(SecurityUtil.collectRoles(method.getDeclaringClass().getAnnotation(RequireRoles.class)));
        if (method.getDeclaringClass().isAnnotationPresent(RequireRole.class)) {
            roles.add(method.getDeclaringClass().getAnnotation(RequireRole.class).value());
        }
        return roles;
    }

    private static Collection<String> collectRoles(RequireRoles requireRoles) {
        if (requireRoles == null) {
            return Collections.emptyList();
        }
        ArrayList<String> roles = new ArrayList<String>();
        for (RequireRole role : requireRoles.value()) {
            roles.add(role.value());
        }
        return roles;
    }
}

