/*
 * Decompiled with CFR 0.152.
 */
package fathom.realm.ldap;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.typesafe.config.Config;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import fathom.authc.Credentials;
import fathom.authc.StandardCredentials;
import fathom.realm.Account;
import fathom.realm.CachingRealm;
import fathom.utils.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapRealm
extends CachingRealm {
    private static final Logger log = LoggerFactory.getLogger(LdapRealm.class);
    protected String ldapUrl;
    protected String ldapUsername;
    protected String ldapPassword;
    protected String ldapBindPattern;
    protected String accountBase;
    protected String accountPattern;
    protected String groupBase;
    protected String groupMemberPattern;
    protected String nameMapping;
    protected String emailMapping;
    protected List<String> adminGroups;

    public static final String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    public void setup(Config config) {
        super.setup(config);
        this.ldapUrl = Strings.emptyToNull((String)config.getString("url"));
        Preconditions.checkNotNull((Object)this.ldapUrl, (Object)"The LDAP 'url' setting may not be null nor empty!");
        this.ldapUsername = "";
        if (config.hasPath("username")) {
            this.ldapUsername = config.getString("username");
        }
        this.ldapPassword = "";
        if (config.hasPath("password")) {
            this.ldapPassword = config.getString("password");
        }
        this.ldapBindPattern = "";
        if (config.hasPath("bindPattern")) {
            this.ldapBindPattern = config.getString("bindPattern");
        }
        this.accountBase = "";
        if (config.hasPath("accountBase")) {
            this.accountBase = config.getString("accountBase");
        }
        this.accountPattern = "(&(objectClass=person)(sAMAccountName=${username}))";
        if (config.hasPath("accountPattern")) {
            this.accountPattern = config.getString("accountPattern");
        }
        if (config.hasPath("nameMapping")) {
            this.nameMapping = config.getString("nameMapping");
        }
        if (config.hasPath("emailMapping")) {
            this.emailMapping = config.getString("emailMapping");
        }
        this.groupBase = "";
        if (config.hasPath("groupBase")) {
            config.getString("groupBase");
        }
        this.groupMemberPattern = "(&(objectClass=group)(member=${dn}))";
        if (config.hasPath("groupMemberPattern")) {
            this.groupMemberPattern = config.getString("groupMemberPattern");
        }
        if (config.hasPath("adminGroups")) {
            this.adminGroups = config.getStringList("adminGroups");
        }
    }

    public void start() {
        log.debug("Realm '{}' configuration:", (Object)this.getRealmName());
        Util.logSetting((Logger)log, (String)"url", (Object)this.ldapUrl);
        Util.logSetting((Logger)log, (String)"username", (Object)this.ldapUsername);
        Util.logSetting((Logger)log, (String)"password", (Object)this.ldapPassword);
        Util.logSetting((Logger)log, (String)"bindPattern", (Object)this.ldapBindPattern);
        Util.logSetting((Logger)log, (String)"accountBase", (Object)this.accountBase);
        Util.logSetting((Logger)log, (String)"accountPattern", (Object)this.accountPattern);
        Util.logSetting((Logger)log, (String)"nameMapping", (Object)this.nameMapping);
        Util.logSetting((Logger)log, (String)"emailMapping", (Object)this.emailMapping);
        Util.logSetting((Logger)log, (String)"groupBase", (Object)this.groupBase);
        Util.logSetting((Logger)log, (String)"groupMemberPattern", (Object)this.groupMemberPattern);
        Util.logSetting((Logger)log, (String)"adminGroups", this.adminGroups);
        super.logCacheSettings(log);
    }

    public void stop() {
    }

    public Account authenticate(StandardCredentials requestCredentials) {
        String username = this.getSimpleUsername(requestCredentials.getUsername());
        String password = requestCredentials.getPassword();
        if (this.hasAccount(username)) {
            return super.authenticate(new StandardCredentials(username, password));
        }
        return this.authenticate(username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account authenticate(String username, String password) {
        block15: {
            LDAPConnection ldapConnection = this.getLdapConnection();
            if (ldapConnection != null) {
                try {
                    String searchPattern;
                    SearchResult result;
                    boolean alreadyAuthenticated = false;
                    if (!Strings.isNullOrEmpty((String)this.ldapBindPattern)) {
                        try {
                            String bindUser = this.ldapBindPattern.replace("${username}", LdapRealm.escapeLDAPSearchFilter(username));
                            ldapConnection.bind(bindUser, password);
                            alreadyAuthenticated = true;
                        }
                        catch (LDAPException e) {
                            Account account = null;
                            ldapConnection.close();
                            return account;
                        }
                    }
                    if ((result = this.doSearch(ldapConnection, this.accountBase, searchPattern = this.accountPattern.replace("${username}", LdapRealm.escapeLDAPSearchFilter(username)))) != null && result.getEntryCount() == 1) {
                        SearchResultEntry accountSearchResult = (SearchResultEntry)result.getSearchEntries().get(0);
                        String accountDN = accountSearchResult.getDN();
                        if (alreadyAuthenticated || this.isAuthenticated(ldapConnection, accountDN, password)) {
                            log.debug("Authentication succeeded for '{}' against '{}'", (Object)username, (Object)this.getRealmName());
                            Account account = null;
                            LdapRealm ldapRealm = this;
                            synchronized (ldapRealm) {
                                account = new Account(username, (Credentials)new StandardCredentials(username, password));
                                this.setAccountRoles(ldapConnection, accountSearchResult, account);
                                this.setAccountAttributes(accountSearchResult, account);
                                this.cacheAccount(account);
                            }
                            ldapRealm = account;
                            return ldapRealm;
                        }
                        log.debug("Authentication failed for '{}' against '{}'", (Object)username, (Object)this.getRealmName());
                        break block15;
                    }
                    if (result == null || result.getSearchEntries().size() == 0) {
                        log.debug("No account found for '{}' in '{}'", (Object)username, (Object)this.getRealmName());
                    }
                }
                finally {
                    ldapConnection.close();
                }
            }
        }
        return null;
    }

    private LDAPConnection getLdapConnection() {
        try {
            ExtendedResult extendedResult;
            LDAPConnection conn;
            SSLUtil sslUtil;
            URI ldapUrl = new URI(this.ldapUrl);
            String ldapHost = ldapUrl.getHost();
            int ldapPort = ldapUrl.getPort();
            if (ldapUrl.getScheme().equalsIgnoreCase("ldaps")) {
                sslUtil = new SSLUtil((TrustManager)new TrustAllTrustManager());
                conn = new LDAPConnection((SocketFactory)sslUtil.createSSLSocketFactory());
                if (ldapPort == -1) {
                    ldapPort = 636;
                }
            } else if (ldapUrl.getScheme().equalsIgnoreCase("ldap") || ldapUrl.getScheme().equalsIgnoreCase("ldap+tls")) {
                conn = new LDAPConnection();
                if (ldapPort == -1) {
                    ldapPort = 389;
                }
            } else {
                log.error("Unsupported LDAP URL scheme: " + ldapUrl.getScheme());
                return null;
            }
            conn.connect(ldapHost, ldapPort);
            if (ldapUrl.getScheme().equalsIgnoreCase("ldap+tls") && (extendedResult = conn.processExtendedOperation((ExtendedRequest)new StartTLSExtendedRequest((sslUtil = new SSLUtil((TrustManager)new TrustAllTrustManager())).createSSLContext()))).getResultCode() != ResultCode.SUCCESS) {
                throw new LDAPException(extendedResult.getResultCode());
            }
            if (Strings.isNullOrEmpty((String)this.ldapUsername) && Strings.isNullOrEmpty((String)this.ldapPassword)) {
                conn.bind((BindRequest)new SimpleBindRequest());
            } else {
                conn.bind((BindRequest)new SimpleBindRequest(this.ldapUsername, this.ldapPassword));
            }
            return conn;
        }
        catch (URISyntaxException e) {
            log.error("Bad LDAP URL, should be in the form: ldap(s|+tls)://<server>:<port>", (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            log.error("Unable to create SSL Connection", (Throwable)e);
        }
        catch (LDAPException e) {
            if (!Strings.isNullOrEmpty((String)e.getDiagnosticMessage())) {
                log.error(e.getDiagnosticMessage());
            }
            log.error("Error connecting to LDAP server", (Throwable)e);
        }
        return null;
    }

    private boolean isAuthenticated(LDAPConnection ldapConnection, String userDn, String password) {
        try {
            ldapConnection.bind(userDn, password);
            return true;
        }
        catch (LDAPException e) {
            if (!Strings.isNullOrEmpty((String)e.getDiagnosticMessage())) {
                log.error(e.getDiagnosticMessage());
            } else {
                log.error("Error authenticating user", (Throwable)e);
            }
            return false;
        }
    }

    private SearchResult doSearch(LDAPConnection ldapConnection, String base, String filter) {
        try {
            return ldapConnection.search(base, SearchScope.SUB, filter, new String[0]);
        }
        catch (LDAPSearchException e) {
            if (!Strings.isNullOrEmpty((String)e.getDiagnosticMessage())) {
                log.error(e.getDiagnosticMessage());
            } else {
                log.error("Problem searching LDAP", (Throwable)e);
            }
            return null;
        }
    }

    private SearchResult doSearch(LDAPConnection ldapConnection, String base, boolean dereferenceAliases, String filter, List<String> attributes) {
        try {
            SearchRequest searchRequest = new SearchRequest(base, SearchScope.SUB, filter, new String[0]);
            if (dereferenceAliases) {
                searchRequest.setDerefPolicy(DereferencePolicy.SEARCHING);
            }
            if (attributes != null) {
                searchRequest.setAttributes(attributes);
            }
            return ldapConnection.search(searchRequest);
        }
        catch (LDAPException e) {
            if (!Strings.isNullOrEmpty((String)e.getDiagnosticMessage())) {
                log.error(e.getDiagnosticMessage());
            } else {
                log.error("Problem searching LDAP", (Throwable)e);
            }
            return null;
        }
    }

    private void setAccountRoles(LDAPConnection ldapConnection, SearchResultEntry accountSearchResult, Account account) {
        String accountDN = accountSearchResult.getDN();
        String groupMemberPattern = this.groupMemberPattern.replace("${dn}", LdapRealm.escapeLDAPSearchFilter(accountDN));
        groupMemberPattern = groupMemberPattern.replace("${username}", LdapRealm.escapeLDAPSearchFilter(account.getUsername()));
        for (Attribute attribute : accountSearchResult.getAttributes()) {
            groupMemberPattern = groupMemberPattern.replace("${" + attribute.getName() + "}", LdapRealm.escapeLDAPSearchFilter(attribute.getValue()));
        }
        SearchResult groupsSearchResult = this.doSearch(ldapConnection, this.groupBase, true, groupMemberPattern, Arrays.asList("cn"));
        if (groupsSearchResult != null && groupsSearchResult.getEntryCount() > 0) {
            for (int i = 0; i < groupsSearchResult.getEntryCount(); ++i) {
                SearchResultEntry groupEntry = (SearchResultEntry)groupsSearchResult.getSearchEntries().get(i);
                String roleName = groupEntry.getAttribute("cn").getValue();
                account.getAuthorizations().addRole(roleName);
            }
        }
    }

    private void setAccountAttributes(SearchResultEntry userSearchResult, Account account) {
        Attribute attribute;
        String pattern;
        this.setAdminAttribute(account);
        if (!Strings.isNullOrEmpty((String)this.nameMapping)) {
            if (this.nameMapping.contains("${")) {
                pattern = this.nameMapping;
                for (Attribute userAttribute : userSearchResult.getAttributes()) {
                    pattern = pattern.replace("${" + userAttribute.getName() + "}", userAttribute.getValue());
                }
                account.setName(pattern);
            } else {
                attribute = userSearchResult.getAttribute(this.nameMapping);
                if (attribute != null && attribute.hasValue()) {
                    account.setName(attribute.getValue());
                }
            }
        }
        if (!Strings.isNullOrEmpty((String)this.emailMapping)) {
            if (this.emailMapping.contains("${")) {
                pattern = this.emailMapping;
                for (Attribute userAttribute : userSearchResult.getAttributes()) {
                    pattern = pattern.replace("${" + userAttribute.getName() + "}", userAttribute.getValue());
                }
                account.addEmailAddress(pattern);
            } else {
                attribute = userSearchResult.getAttribute(this.emailMapping);
                if (attribute != null && attribute.hasValue()) {
                    account.addEmailAddress(attribute.getValue());
                }
            }
        }
    }

    private void setAdminAttribute(Account account) {
        if (this.adminGroups != null) {
            for (String adminGroup : this.adminGroups) {
                if (adminGroup.startsWith("@") && account.getUsername().equalsIgnoreCase(adminGroup.substring(1))) {
                    account.getAuthorizations().addPermission("*");
                    continue;
                }
                if (!account.hasRole(adminGroup)) continue;
                account.getAuthorizations().addPermission("*");
            }
        }
    }

    private String getSimpleUsername(String username) {
        int lastSlash = username.lastIndexOf(92);
        if (lastSlash > -1) {
            username = username.substring(lastSlash + 1);
        }
        return username;
    }
}

