/*
 * Decompiled with CFR 0.152.
 */
package fathom.realm.pam;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import fathom.authc.Credentials;
import fathom.authc.StandardCredentials;
import fathom.realm.Account;
import fathom.realm.CachingRealm;
import fathom.utils.Util;
import java.io.File;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PamRealm
extends CachingRealm {
    private static Logger log = LoggerFactory.getLogger(PamRealm.class);
    private String serviceName;

    public void setup(Config config) {
        super.setup(config);
        String os = System.getProperty("os.name").toLowerCase();
        Preconditions.checkState((!os.startsWith("windows") ? 1 : 0) != 0, (String)"PAM authentication is not supported on '{0}'", (Object[])new Object[]{os});
        String[] files = new String[]{"/etc/shadow", "/etc/master.passwd"};
        File passwdFile = null;
        for (String name : files) {
            File f = new File(name);
            if (!f.exists()) continue;
            passwdFile = f;
            break;
        }
        if (passwdFile == null) {
            log.warn("Could not find a passwd database!");
        } else if (!passwdFile.canRead()) {
            log.warn("Can not read passwd database {}! PAM authentications may fail!", (Object)passwdFile);
        }
        this.serviceName = "system-auth";
        if (config.hasPath("serviceName")) {
            this.serviceName = config.getString("serviceName");
        }
    }

    public void start() {
        log.debug("Realm '{}' configuration:", (Object)this.getRealmName());
        Util.logSetting((Logger)log, (String)"serviceName", (Object)this.serviceName);
        super.logCacheSettings(log);
    }

    public void stop() {
    }

    public Account authenticate(StandardCredentials requestCredentials) {
        String username = requestCredentials.getUsername();
        String password = requestCredentials.getPassword();
        if (this.hasAccount(username)) {
            return super.authenticate(requestCredentials);
        }
        return this.authenticate(username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account authenticate(String username, String password) {
        PAM pam = null;
        try {
            pam = new PAM(this.serviceName);
            pam.authenticate(username, password);
            log.debug("Authentication succeeded for '{}' against '{}'", (Object)username, (Object)this.getRealmName());
            Account account = new Account(null, (Credentials)new StandardCredentials(username, password));
            this.cacheAccount(account);
            Account account2 = account;
            return account2;
        }
        catch (PAMException e) {
            log.debug("Authentication failed for '{}' against '{}'", (Object)username, (Object)this.getRealmName());
            log.error(e.getMessage());
        }
        finally {
            if (pam != null) {
                pam.dispose();
            }
        }
        return null;
    }
}

