/*
 * Decompiled with CFR 0.152.
 */
package fathom.authc;

import com.google.common.base.Preconditions;
import fathom.authc.AuthenticationToken;
import fathom.authc.Credentials;

public class StandardCredentials
implements AuthenticationToken,
Credentials {
    private final String username;
    private final String password;

    public StandardCredentials(String username, String password) {
        Preconditions.checkNotNull((Object)username, (Object)"Username may not be null!");
        this.username = username.trim();
        this.password = password == null ? null : password.trim();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public Credentials sanitize() {
        return new StandardCredentials(this.username, null);
    }

    public String toString() {
        return "StandardCredentials{username='" + this.username + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardCredentials that = (StandardCredentials)o;
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }
}

