/*
 * Decompiled with CFR 0.152.
 */
package fathom.authz;

import fathom.authz.Permission;
import fathom.authz.Role;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class Authorizations
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8777587779337470374L;
    protected final Set<Role> roles;
    protected final Set<Permission> permissions;
    protected transient Collection<Permission> aggregatePermissions;

    public Authorizations() {
        this(new LinkedHashSet<String>());
    }

    public Authorizations(Set<String> roles) {
        this(new LinkedHashSet<Role>(), new LinkedHashSet<Permission>());
        for (String role : roles) {
            this.addRole(role);
        }
    }

    public Authorizations(Set<Role> roles, Set<Permission> permissions) {
        this.roles = roles;
        this.permissions = permissions;
        this.aggregatePermissions = null;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public Authorizations setRoles(Set<Role> roles) {
        this.roles.clear();
        this.aggregatePermissions = null;
        this.addRoles(roles);
        return this;
    }

    public Authorizations addRoles(String ... roles) {
        for (String role : roles) {
            this.addRole(new Role(role));
        }
        return this;
    }

    public Authorizations addRoles(Collection<Role> roles) {
        this.roles.addAll(roles);
        this.aggregatePermissions = null;
        return this;
    }

    public Authorizations addRole(String role) {
        this.addRole(new Role(role));
        return this;
    }

    public Authorizations addRole(Role role) {
        this.roles.add(role);
        this.aggregatePermissions = null;
        return this;
    }

    public Authorizations addPermissions(String ... permissions) {
        for (String permission : permissions) {
            this.addPermission(permission);
        }
        return this;
    }

    public Authorizations addPermission(String permission) {
        this.permissions.add(new Permission(permission));
        this.aggregatePermissions = null;
        return this;
    }

    public Authorizations addPermissions(Collection<Permission> permissions) {
        this.permissions.addAll(permissions);
        this.aggregatePermissions = null;
        return this;
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<Permission> permissions) {
        this.permissions.clear();
        this.aggregatePermissions = null;
        this.addPermissions(permissions);
    }

    public boolean isPermitted(String permission) {
        return this.isPermitted(new Permission(permission));
    }

    public boolean[] isPermitted(String ... permissions) {
        boolean[] rights = new boolean[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            Permission permission = new Permission(permissions[i]);
            rights[i] = this.isPermitted(permission);
        }
        return rights;
    }

    public boolean isPermittedAll(String ... permissions) {
        for (boolean permitted : this.isPermitted(permissions)) {
            if (permitted) continue;
            return false;
        }
        return true;
    }

    public boolean isPermittedAll(Collection<String> permissions) {
        for (boolean permitted : this.isPermitted(permissions.toArray(new String[permissions.size()]))) {
            if (permitted) continue;
            return false;
        }
        return true;
    }

    protected boolean isPermitted(Permission permission) {
        for (Permission perm : this.getAggregatePermissions()) {
            if (!perm.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(String roleIdentifier) {
        return this.roles.contains(new Role(roleIdentifier));
    }

    public boolean hasRoles(String ... roleIdentifiers) {
        ArrayList<Role> requiredRoles = new ArrayList<Role>();
        for (String roleIdentifier : roleIdentifiers) {
            requiredRoles.add(new Role(roleIdentifier));
        }
        return this.roles.containsAll(requiredRoles);
    }

    public boolean hasRoles(Collection<String> roleIdentifiers) {
        ArrayList<Role> requiredRoles = new ArrayList<Role>();
        for (String roleIdentifier : roleIdentifiers) {
            requiredRoles.add(new Role(roleIdentifier));
        }
        return this.roles.containsAll(requiredRoles);
    }

    public Collection<Permission> getAggregatePermissions() {
        if (this.aggregatePermissions == null) {
            LinkedHashSet<Permission> perms = new LinkedHashSet<Permission>();
            perms.addAll(this.permissions);
            for (Role role : this.roles) {
                perms.addAll(role.getPermissions());
            }
            this.aggregatePermissions = perms.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(perms);
        }
        return this.aggregatePermissions;
    }

    public Authorizations clone() {
        Authorizations clone = new Authorizations(this.roles, this.permissions);
        return clone;
    }
}

