/*
 * Decompiled with CFR 0.152.
 */
package fathom.authz;

import com.google.common.base.Joiner;
import fathom.utils.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Permission
implements Serializable {
    protected static final String WILDCARD_TOKEN = "*";
    protected static final String PART_DIVIDER_TOKEN = ":";
    protected static final String SUBPART_DIVIDER_TOKEN = ",";
    protected static final boolean DEFAULT_CASE_SENSITIVE = false;
    private List<Set<String>> parts;

    protected Permission() {
    }

    public Permission(String wildcardString) {
        this(wildcardString, false);
    }

    public Permission(String wildcardString, boolean caseSensitive) {
        this.setParts(wildcardString, caseSensitive);
    }

    protected void setParts(String wildcardString, boolean caseSensitive) {
        if (wildcardString == null || wildcardString.trim().length() == 0) {
            throw new IllegalArgumentException("Wildcard string cannot be null or empty. Make sure permission strings are properly formatted.");
        }
        wildcardString = wildcardString.trim();
        List<String> parts = Arrays.asList(wildcardString.split(PART_DIVIDER_TOKEN));
        this.parts = new ArrayList<Set<String>>();
        for (String part : parts) {
            Set<String> subparts = Util.splitToSet((String)part, (String)SUBPART_DIVIDER_TOKEN);
            if (!caseSensitive) {
                subparts = this.lowercase(subparts);
            }
            if (subparts.isEmpty()) {
                throw new IllegalArgumentException("Wildcard string cannot contain parts with only dividers. Make sure permission strings are properly formatted.");
            }
            this.parts.add(subparts);
        }
        if (this.parts.isEmpty()) {
            throw new IllegalArgumentException("Wildcard string cannot contain only dividers. Make sure permission strings are properly formatted.");
        }
    }

    private Set<String> lowercase(Set<String> subparts) {
        LinkedHashSet<String> lowerCasedSubparts = new LinkedHashSet<String>(subparts.size());
        for (String subpart : subparts) {
            lowerCasedSubparts.add(subpart.toLowerCase());
        }
        return lowerCasedSubparts;
    }

    protected List<Set<String>> getParts() {
        return this.parts;
    }

    protected void setParts(String wildcardString) {
        this.setParts(wildcardString, false);
    }

    public boolean implies(Permission p) {
        List<Set<String>> otherParts = p.getParts();
        int i = 0;
        for (Set<String> otherPart : otherParts) {
            if (this.getParts().size() - 1 < i) {
                return true;
            }
            Set<String> part = this.getParts().get(i);
            if (!part.contains(WILDCARD_TOKEN) && !part.containsAll(otherPart)) {
                return false;
            }
            ++i;
        }
        while (i < this.getParts().size()) {
            Set<String> part = this.getParts().get(i);
            if (!part.contains(WILDCARD_TOKEN)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return Joiner.on((char)':').join(this.parts);
    }

    public boolean equals(Object o) {
        if (o instanceof Permission) {
            Permission p = (Permission)o;
            return this.parts.equals(p.parts);
        }
        return false;
    }

    public int hashCode() {
        return this.parts.hashCode();
    }
}

