/*
 * Decompiled with CFR 0.152.
 */
package fathom.authz;

import com.google.common.base.Joiner;
import fathom.authz.Permission;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class Role
implements Serializable {
    protected final String name;
    protected final Set<Permission> permissions;

    public Role(String name) {
        this(name, new String[0]);
    }

    public Role(String name, String ... permissions) {
        this.name = name.trim();
        this.permissions = new LinkedHashSet<Permission>();
        this.addPermissions(permissions);
    }

    public Role(String name, Set<Permission> permissions) {
        this.name = name.trim();
        this.permissions = new LinkedHashSet<Permission>();
        this.addPermissions(permissions);
    }

    public String getName() {
        return this.name;
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions.clear();
        this.permissions.addAll(permissions);
    }

    public Role addPermission(String permission) {
        this.permissions.add(new Permission(permission));
        return this;
    }

    public Role addPermission(Permission permission) {
        this.permissions.add(permission);
        return this;
    }

    public Role addPermissions(String ... perms) {
        for (String permission : perms) {
            this.permissions.add(new Permission(permission));
        }
        return this;
    }

    public Role addPermissions(Collection<Permission> perms) {
        if (perms != null && !perms.isEmpty()) {
            this.permissions.addAll(perms);
        }
        return this;
    }

    public boolean isPermitted(String permission) {
        return this.isPermitted(new Permission(permission));
    }

    public boolean isPermitted(Permission permission) {
        for (Permission perm : this.permissions) {
            if (!perm.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Role) {
            Role sr = (Role)o;
            return this.getName() != null ? this.getName().equals(sr.getName()) : sr.getName() == null;
        }
        return false;
    }

    public String toString() {
        return "Role{name='" + this.getName() + "', permissions=" + Joiner.on((char)',').join(this.permissions) + "}";
    }
}

