/*
 * Decompiled with CFR 0.152.
 */
package fathom.realm;

import com.google.common.base.Optional;
import fathom.authc.AuthenticationException;
import fathom.authc.Credentials;
import fathom.authc.StandardCredentials;
import fathom.authz.AuthorizationException;
import fathom.authz.Authorizations;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class Account
implements Serializable {
    public static final transient Account GUEST = new Account("Guest", new StandardCredentials("guest", null), new Authorizations(Collections.emptySet(), Collections.emptySet()));
    private static final long serialVersionUID = 2533708087596778061L;
    protected final Credentials credentials;
    protected final Authorizations authorizations;
    protected final Set<String> emailAddresses;
    protected final Set<String> tokens;
    protected String name;
    protected boolean isDisabled;

    public Account(String name, Credentials credentials) {
        this(name, credentials, new Authorizations());
    }

    public Account(String name, Credentials credentials, Authorizations authorizations) {
        this.name = name;
        this.credentials = credentials;
        this.authorizations = authorizations;
        this.emailAddresses = new LinkedHashSet<String>();
        this.tokens = new HashSet<String>();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.credentials.getUsername();
    }

    public void addEmailAddress(String address) {
        this.emailAddresses.add(address);
    }

    public void addEmailAddresses(String ... addresses) {
        this.emailAddresses.addAll(Arrays.asList(addresses));
    }

    public void addEmailAddresses(Collection<String> addresses) {
        this.emailAddresses.addAll(addresses);
    }

    public String getEmailAddress() {
        if (this.emailAddresses.isEmpty()) {
            return null;
        }
        return this.emailAddresses.toArray()[0].toString();
    }

    public Collection<String> getEmailAddresses() {
        return Collections.unmodifiableCollection(this.emailAddresses);
    }

    public void addToken(String token) {
        this.tokens.add(token);
    }

    public void addTokens(String ... tokens) {
        this.tokens.addAll(Arrays.asList(tokens));
    }

    public void addTokens(Collection<String> tokens) {
        this.tokens.addAll(tokens);
    }

    public String getToken() {
        if (this.tokens.isEmpty()) {
            return null;
        }
        return this.tokens.toArray()[0].toString();
    }

    public Collection<String> getTokens() {
        return Collections.unmodifiableCollection(this.tokens);
    }

    public void setDisabled() {
        this.isDisabled = true;
    }

    public void setEnabled() {
        this.isDisabled = false;
    }

    public String toString() {
        return (String)Optional.fromNullable((Object)this.name).or((Object)this.credentials.getUsername());
    }

    public boolean isGuest() {
        return this == GUEST;
    }

    public boolean isAuthenticated() {
        return !this.isGuest();
    }

    public boolean isAdministrator() {
        return this.isPermitted("*");
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public boolean isEnabled() {
        return !this.isDisabled;
    }

    public void checkGuest() throws AuthenticationException {
        if (!this.isGuest()) {
            throw new AuthorizationException("'{}' is not the Guest account", this.toString());
        }
    }

    public void checkAuthenticated() throws AuthenticationException {
        if (!this.isAuthenticated()) {
            throw new AuthorizationException("'{}' has not authenticated", this.toString());
        }
    }

    public void checkAdministrator() throws AuthenticationException {
        if (!this.isAdministrator()) {
            throw new AuthorizationException("'{}' is not an administrator", this.toString());
        }
    }

    public boolean isPermitted(String permission) {
        return this.authorizations.isPermitted(permission);
    }

    public boolean[] isPermitted(String ... permissions) {
        return this.authorizations.isPermitted(permissions);
    }

    public boolean isPermittedAll(String ... permissions) {
        return this.authorizations.isPermittedAll(permissions);
    }

    public boolean isPermittedAll(Collection<String> permissions) {
        return this.authorizations.isPermittedAll(permissions);
    }

    public void checkPermission(String permission) throws AuthorizationException {
        if (!this.isPermitted(permission)) {
            throw new AuthorizationException("'{}' does not have the permission '{}'", this.toString(), permission);
        }
    }

    public void checkPermissions(String ... permissions) throws AuthorizationException {
        if (!this.isPermittedAll(permissions)) {
            throw new AuthorizationException("'{}' does not have the permissions {}", this.toString(), Arrays.toString(permissions));
        }
    }

    public void checkPermissions(Collection<String> permissions) throws AuthorizationException {
        if (!this.isPermittedAll(permissions)) {
            throw new AuthorizationException("'{}' does not have the permissions {}", this.toString(), permissions);
        }
    }

    public boolean hasRole(String roleIdentifier) {
        return this.authorizations.hasRole(roleIdentifier);
    }

    public boolean hasRoles(String ... roleIdentifiers) {
        return this.authorizations.hasRoles(roleIdentifiers);
    }

    public boolean hasRoles(Collection<String> roleIdentifiers) {
        return this.authorizations.hasRoles(roleIdentifiers);
    }

    public void checkRole(String roleIdentifier) throws AuthorizationException {
        if (!this.hasRole(roleIdentifier)) {
            throw new AuthorizationException("'{}' does not have the role '{}'", this.toString(), roleIdentifier);
        }
    }

    public void checkRoles(String ... roleIdentifiers) throws AuthorizationException {
        if (!this.hasRoles(roleIdentifiers)) {
            throw new AuthorizationException("'{}' does not have the roles {}", this.toString(), Arrays.toString(roleIdentifiers));
        }
    }

    public void checkRoles(Collection<String> roleIdentifiers) throws AuthorizationException {
        if (!this.hasRoles(roleIdentifiers)) {
            throw new AuthorizationException("'{}' does not have the roles {}", this.toString(), roleIdentifiers);
        }
    }

    public boolean hasToken(String token) {
        return this.tokens.contains(token);
    }

    public void checkToken(String token) throws AuthorizationException {
        if (!this.hasToken(token)) {
            throw new AuthorizationException("'{}' does not have the token '{}'", this.toString(), token);
        }
    }
}

