/*
 * Decompiled with CFR 0.152.
 */
package fathom.realm;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.typesafe.config.Config;
import fathom.realm.Account;
import fathom.realm.StandardCredentialsRealm;
import fathom.utils.Util;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class CachingRealm
extends StandardCredentialsRealm {
    int cacheTtl;
    int cacheMax;
    private String realmName;
    private Cache<String, Account> accountCache;

    @Override
    public String getRealmName() {
        return this.realmName;
    }

    @Override
    public void setup(Config config) {
        this.realmName = this.getClass().getSimpleName();
        if (config.hasPath("name")) {
            this.realmName = config.getString("name");
        }
        if (config.hasPath("cacheTtl")) {
            this.cacheTtl = config.getInt("cacheTtl");
        }
        if (config.hasPath("cacheMax")) {
            this.cacheMax = config.getInt("cacheMax");
        }
        if (this.cacheTtl > 0 && this.cacheMax > 0) {
            this.accountCache = CacheBuilder.newBuilder().expireAfterAccess((long)this.cacheTtl, TimeUnit.MINUTES).maximumSize((long)this.cacheMax).build();
        }
    }

    protected void logCacheSettings(Logger log) {
        Util.logSetting((Logger)log, (String)"caching", (Object)(this.accountCache != null ? 1 : 0));
        Util.logSetting((Logger)log, (String)"cacheTtl (mins)", (Object)this.cacheTtl);
        Util.logSetting((Logger)log, (String)"cacheMax (accounts)", (Object)this.cacheMax);
    }

    @Override
    public boolean hasAccount(String username) {
        return this.accountCache != null && this.accountCache.getIfPresent((Object)username) != null;
    }

    @Override
    public Account getAccount(String username) {
        if (this.accountCache != null) {
            Account account = (Account)this.accountCache.getIfPresent((Object)username);
            return account;
        }
        return null;
    }

    protected void cacheAccount(Account account) {
        if (this.accountCache != null) {
            this.accountCache.put((Object)account.getUsername(), (Object)account);
        }
    }

    public void clearCache() {
        if (this.accountCache != null) {
            this.accountCache.invalidateAll();
        }
    }
}

