/*
 * Decompiled with CFR 0.152.
 */
package fathom.realm;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import fathom.authc.AuthenticationToken;
import fathom.realm.Account;
import fathom.realm.MemoryRealm;
import fathom.utils.Util;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRealm
extends MemoryRealm {
    private static final Logger log = LoggerFactory.getLogger(FileRealm.class);
    private volatile File realmFile;
    private volatile long lastModified;

    @Override
    public void setup(Config config) {
        super.setup(config);
        String file = Strings.emptyToNull((String)config.getString("file"));
        Preconditions.checkNotNull((Object)file, (Object)"The [file] setting must be set!");
        File realmFile = new File(file);
        this.setFile(realmFile);
    }

    public void setFile(File realmFile) {
        this.realmFile = realmFile;
        this.readFile();
    }

    @Override
    public void start() {
        log.debug("Realm '{}' configuration:", (Object)this.getRealmName());
        Util.logSetting((Logger)log, (String)"file", (Object)this.realmFile);
    }

    @Override
    public Account authenticate(AuthenticationToken authenticationToken) {
        this.readFile();
        return super.authenticate(authenticationToken);
    }

    protected synchronized void readFile() {
        if (this.realmFile != null && this.realmFile.exists() && this.realmFile.lastModified() != this.lastModified) {
            this.lastModified = this.realmFile.lastModified();
            try {
                Preconditions.checkArgument((boolean)this.realmFile.canRead(), (String)"The file '{}' can not be read!", (Object[])new Object[]{this.realmFile});
                Config config = ConfigFactory.parseFile((File)this.realmFile);
                super.setup(config);
            }
            catch (Exception e) {
                log.error("Failed to read {}", (Object)this.realmFile, (Object)e);
            }
        }
    }
}

