/*
 * Decompiled with CFR 0.152.
 */
package fathom.realm;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.typesafe.config.Config;
import fathom.authc.AuthenticationToken;
import fathom.authc.StandardCredentials;
import fathom.authc.TokenCredentials;
import fathom.authz.Role;
import fathom.realm.Account;
import fathom.realm.StandardCredentialsRealm;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryRealm
extends StandardCredentialsRealm {
    private static final Logger log = LoggerFactory.getLogger(MemoryRealm.class);
    private final Map<String, Account> accounts;
    private final Map<String, Account> tokens;
    private final Map<String, Role> definedRoles;
    private String realmName = this.getClass().getSimpleName();

    public MemoryRealm() {
        this.accounts = new ConcurrentHashMap<String, Account>();
        this.tokens = new ConcurrentHashMap<String, Account>();
        this.definedRoles = new ConcurrentHashMap<String, Role>();
    }

    @Override
    public boolean canAuthenticate(AuthenticationToken authenticationToken) {
        return authenticationToken instanceof StandardCredentials || authenticationToken instanceof TokenCredentials;
    }

    @Override
    public Account authenticate(AuthenticationToken authenticationToken) {
        if (authenticationToken instanceof StandardCredentials) {
            return super.authenticate(authenticationToken);
        }
        if (authenticationToken instanceof TokenCredentials) {
            return this.authenticateToken((TokenCredentials)authenticationToken);
        }
        return null;
    }

    @Override
    public synchronized void setup(Config config) {
        if (config.hasPath("name")) {
            this.realmName = config.getString("name");
        }
        this.definedRoles.clear();
        this.definedRoles.putAll(this.parseDefinedRoles(config));
        this.accounts.clear();
        this.tokens.clear();
        if (config.hasPath("accounts")) {
            for (Config accountConfig : config.getConfigList("accounts")) {
                Account account = this.parseAccount(accountConfig);
                this.addAccount(account);
                log.trace("Added '{}' account to '{}'", (Object)account, (Object)this.getRealmName());
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    protected Account parseAccount(Config accountConfig) {
        String username = Strings.emptyToNull((String)accountConfig.getString("username"));
        Preconditions.checkNotNull((Object)username, (Object)"The 'username' setting may not be null nor empty!");
        String name = null;
        if (accountConfig.hasPath("name")) {
            name = accountConfig.getString("name");
        }
        String password = null;
        if (accountConfig.hasPath("password")) {
            password = accountConfig.getString("password");
        }
        StandardCredentials credentials = new StandardCredentials(username, password);
        Account account = new Account(name, credentials);
        if (accountConfig.hasPath("emailAddresses")) {
            account.addEmailAddresses(accountConfig.getStringList("emailAddresses"));
        }
        if (accountConfig.hasPath("tokens")) {
            account.addTokens(accountConfig.getStringList("tokens"));
            for (String token : account.getTokens()) {
                if (this.tokens.containsKey(token)) {
                    String otherAccount = this.tokens.get(token).getUsername();
                    log.error("Token collision: {} has the same token as {}", (Object)account.getUsername(), (Object)otherAccount);
                    continue;
                }
                this.tokens.put(token, account);
            }
        }
        if (accountConfig.hasPath("disabled") && accountConfig.getBoolean("disabled")) {
            account.setDisabled();
        }
        if (accountConfig.hasPath("roles")) {
            for (String role : accountConfig.getStringList("roles")) {
                if (this.definedRoles.containsKey(role)) {
                    Role definedRole = this.definedRoles.get(role);
                    account.getAuthorizations().addRole(definedRole);
                    continue;
                }
                account.getAuthorizations().addRole(role);
            }
        }
        if (accountConfig.hasPath("permissions")) {
            for (String permission : accountConfig.getStringList("permissions")) {
                account.getAuthorizations().addPermission(permission);
            }
        }
        return account;
    }

    protected Map<String, Role> parseDefinedRoles(Config config) {
        HashMap<String, Role> roleMap = new HashMap<String, Role>();
        if (!config.hasPath("roles")) {
            log.trace("'{}' has no roles", (Object)config);
        } else if (config.hasPath("roles")) {
            log.trace("Parsing Role definitions");
            Config roleConfig = config.getConfig("roles");
            for (Map.Entry entry : roleConfig.entrySet()) {
                String name = (String)entry.getKey();
                List permissions = roleConfig.getStringList(name);
                Role role = new Role(name, permissions.toArray(new String[permissions.size()]));
                roleMap.put(role.getName(), role);
            }
        }
        return Collections.unmodifiableMap(roleMap);
    }

    @Override
    public String getRealmName() {
        return this.realmName;
    }

    @Override
    public boolean hasAccount(String username) {
        return this.accounts.containsKey(username);
    }

    @Override
    public Account getAccount(String username) {
        Account account = this.accounts.get(username);
        return account;
    }

    @Override
    public Account authenticate(String username, String password) {
        Account account = this.authenticate(new StandardCredentials(username, password));
        return account;
    }

    public Account authenticateToken(TokenCredentials credentials) {
        return this.tokens.get(credentials.getToken());
    }

    public Account addAccount(String username, String password) {
        return this.addAccount(null, username, password);
    }

    public Account addAccount(String name, String username, String password) {
        StandardCredentials credentials = new StandardCredentials(username, password);
        Account account = new Account(name, credentials);
        return this.addAccount(account);
    }

    public Account addAccount(Account account) {
        this.accounts.putIfAbsent(account.getUsername(), account);
        return account;
    }

    public Account removeAccount(String username) {
        Account account = this.accounts.remove(username);
        return account;
    }
}

