/*
 * Decompiled with CFR 0.152.
 */
package fathom.realm;

import com.google.common.base.Strings;
import fathom.authc.AuthenticationToken;
import fathom.authc.StandardCredentials;
import fathom.realm.Account;
import fathom.realm.Realm;
import fathom.utils.CryptoUtil;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandardCredentialsRealm
implements Realm {
    private static final Logger log = LoggerFactory.getLogger(StandardCredentialsRealm.class);

    public String toString() {
        return this.getRealmName();
    }

    @Override
    public boolean canAuthenticate(AuthenticationToken authenticationToken) {
        return authenticationToken instanceof StandardCredentials;
    }

    public abstract Account authenticate(String var1, String var2);

    @Override
    public Account authenticate(AuthenticationToken authenticationToken) {
        if (authenticationToken instanceof StandardCredentials) {
            StandardCredentials requestCredentials = (StandardCredentials)authenticationToken;
            if (Strings.isNullOrEmpty((String)requestCredentials.getUsername()) || Strings.isNullOrEmpty((String)requestCredentials.getPassword())) {
                return null;
            }
            return this.authenticate(requestCredentials);
        }
        return null;
    }

    public Account authenticate(StandardCredentials requestCredentials) {
        if (this.hasAccount(requestCredentials.getUsername())) {
            Account storedAccount = this.getAccount(requestCredentials.getUsername());
            StandardCredentials storedCredentials = (StandardCredentials)storedAccount.getCredentials();
            if (Strings.isNullOrEmpty((String)storedCredentials.getPassword())) {
                log.debug("Account '{}' in '{}' has no password and may not be used for authentication", (Object)storedAccount.getUsername(), (Object)this.getRealmName());
                return null;
            }
            if (this.validatePassword(requestCredentials, storedCredentials)) {
                log.debug("Authentication succeeded for '{}' against '{}'", (Object)requestCredentials.getUsername(), (Object)this.getRealmName());
                return storedAccount;
            }
            log.debug("Authentication failed for '{}' against '{}'", (Object)requestCredentials.getUsername(), (Object)this.getRealmName());
        } else {
            log.debug("Unknown account '{}' in the '{}' realm", (Object)requestCredentials.getUsername(), (Object)this.getRealmName());
        }
        return null;
    }

    protected boolean validatePassword(StandardCredentials requestCredentials, StandardCredentials storedCredentials) {
        String storedPassword = storedCredentials.getPassword();
        String username = requestCredentials.getUsername();
        String password = requestCredentials.getPassword();
        boolean authenticated = false;
        if (storedPassword.startsWith("{BF}")) {
            if (BCrypt.checkpw((String)password, (String)storedPassword.substring("{BF}".length()))) {
                log.trace("Blowfish hashed password matched for user '{}'", (Object)username);
                authenticated = true;
            }
        } else if (storedPassword.startsWith("{SHA256}")) {
            String shaPassword = CryptoUtil.getHashSHA256((String)password);
            if (storedPassword.substring("{SHA256}".length()).equals(shaPassword)) {
                log.trace("Unsalted SHA-256 hashed password matched for user '{}'", (Object)username);
                authenticated = true;
            }
        } else if (storedPassword.startsWith("{SHA1}")) {
            String shaPassword = CryptoUtil.getHashSHA1((String)password);
            if (storedPassword.substring("{SHA1}".length()).equals(shaPassword)) {
                log.trace("Unsalted SHA-1 hashed password matched for user '{}'", (Object)username);
                authenticated = true;
            }
        } else if (storedPassword.startsWith("{MD5}")) {
            String md5Password = CryptoUtil.getHashMD5((String)password);
            if (storedPassword.substring("{MD5}".length()).equals(md5Password)) {
                log.trace("Unsalted MD5 hashed password matched for user '{}'", (Object)username);
                authenticated = true;
            }
        } else if (storedPassword.equals(password)) {
            log.trace("Clear text password matched for user '{}'", (Object)username);
            authenticated = true;
        }
        return authenticated;
    }
}

