/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.Jmysy.binlog4j.core;

import com.gitee.Jmysy.binlog4j.core.BinlogClientConfig;
import com.gitee.Jmysy.binlog4j.core.BinlogEventHandlerInvoker;
import com.gitee.Jmysy.binlog4j.core.IBinlogClient;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import com.gitee.Jmysy.binlog4j.core.config.RedisConfig;
import com.gitee.Jmysy.binlog4j.core.dispatcher.BinlogEventDispatcher;
import com.gitee.Jmysy.binlog4j.core.enums.BinlogClientMode;
import com.gitee.Jmysy.binlog4j.core.exception.Binlog4jException;
import com.gitee.Jmysy.binlog4j.core.position.BinlogPosition;
import com.gitee.Jmysy.binlog4j.core.position.BinlogPositionHandler;
import com.gitee.Jmysy.binlog4j.core.position.RedisBinlogPositionHandler;
import com.github.shyiko.mysql.binlog.BinaryLogClient;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinlogClient
implements IBinlogClient {
    private static final Logger log = LoggerFactory.getLogger(BinlogClient.class);
    private final BinlogClientConfig clientConfig;
    private BinaryLogClient client;
    private BinlogPositionHandler positionHandler;
    private RedissonClient redissonClient;
    private final Map<String, BinlogEventHandlerInvoker> eventHandlerList = new HashMap<String, BinlogEventHandlerInvoker>();
    private final ExecutorService executor;

    public BinlogClient(BinlogClientConfig clientConfig) {
        this.createPositionHandler(clientConfig);
        this.createRedissonClient(clientConfig);
        this.clientConfig = clientConfig;
        this.executor = Executors.newCachedThreadPool();
    }

    @Override
    public void registerEventHandler(String handlerKey, IBinlogEventHandler eventHandler) {
        BinlogEventHandlerInvoker eventHandlerDetails = new BinlogEventHandlerInvoker();
        eventHandlerDetails.setClientConfig(this.clientConfig);
        eventHandlerDetails.setEventHandler(eventHandler);
        this.eventHandlerList.put(handlerKey, eventHandlerDetails);
    }

    @Override
    public void registerEventHandler(IBinlogEventHandler eventHandler) {
        this.registerEventHandler(UUID.randomUUID().toString(), eventHandler);
    }

    @Override
    public void unregisterEventHandler(String handlerKey) {
        if (this.eventHandlerList.containsKey(handlerKey)) {
            this.eventHandlerList.remove(handlerKey);
        }
    }

    @Override
    public void connect() {
        BinlogClientMode clientMode = this.clientConfig.getMode();
        if (clientMode == BinlogClientMode.cluster) {
            ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1);
            scheduledExecutor.scheduleWithFixedDelay(this::runWithCluster, 0L, 1000L, TimeUnit.MILLISECONDS);
        } else {
            this.executor.submit(this::runWithStandalone);
        }
    }

    @Override
    public void disconnect() {
        if (this.client != null) {
            try {
                this.client.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void runWithStandalone() {
        try {
            BinlogPosition binlogPosition;
            log.info("\u542f\u52a8 Binlog \u5ba2\u6237\u7aef ({}) - \u8fde\u63a5 {}:{} \u670d\u52a1", new Object[]{this.clientConfig.getServerId(), this.clientConfig.getHost(), this.clientConfig.getPort()});
            this.client = new BinaryLogClient(this.clientConfig.getHost(), this.clientConfig.getPort(), this.clientConfig.getUsername(), this.clientConfig.getPassword());
            this.client.registerEventListener((BinaryLogClient.EventListener)new BinlogEventDispatcher(this.clientConfig, this.positionHandler, this.eventHandlerList));
            this.client.setKeepAlive(this.clientConfig.getKeepAlive());
            this.client.setKeepAliveInterval(this.clientConfig.getKeepAliveInterval());
            this.client.setHeartbeatInterval(this.clientConfig.getHeartbeatInterval());
            this.client.setConnectTimeout(this.clientConfig.getConnectTimeout());
            this.client.setServerId(this.clientConfig.getServerId());
            if (this.clientConfig.getPersistence().booleanValue() && !this.clientConfig.isInaugural() && this.positionHandler != null && (binlogPosition = this.positionHandler.loadPosition(this.clientConfig.getServerId())) != null) {
                this.client.setBinlogFilename(binlogPosition.getFilename());
                this.client.setBinlogPosition(binlogPosition.getPosition().longValue());
            }
            this.client.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runWithCluster() {
        RLock lock = this.redissonClient.getLock(this.clientConfig.getKey());
        try {
            if (lock.tryLock()) {
                this.runWithStandalone();
            }
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    private void createPositionHandler(BinlogClientConfig clientConfig) {
        if (clientConfig.getPersistence().booleanValue()) {
            if (clientConfig.getPositionHandler() == null) {
                if (clientConfig.getRedisConfig() == null) {
                    throw new Binlog4jException("Cluster mode or persistence enabled, missing Redis configuration");
                }
                this.positionHandler = new RedisBinlogPositionHandler(clientConfig.getRedisConfig());
            } else {
                this.positionHandler = clientConfig.getPositionHandler();
            }
        }
    }

    private void createRedissonClient(BinlogClientConfig clientConfig) {
        if (clientConfig.getMode() == BinlogClientMode.cluster) {
            RedisConfig redisConfig = clientConfig.getRedisConfig();
            if (redisConfig == null) {
                throw new Binlog4jException("Cluster mode or persistence enabled, missing Redis configuration");
            }
            Config config = new Config();
            SingleServerConfig singleServerConfig = config.useSingleServer();
            singleServerConfig.setAddress("redis://" + redisConfig.getHost() + ":" + redisConfig.getPort());
            singleServerConfig.setPassword(redisConfig.getPassword());
            singleServerConfig.setDatabase(redisConfig.getDatabase());
            config.setLockWatchdogTimeout(10000L);
            this.redissonClient = Redisson.create((Config)config);
        }
    }
}

