/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.Jmysy.binlog4j.core;

import com.gitee.Jmysy.binlog4j.core.config.RedisConfig;
import com.gitee.Jmysy.binlog4j.core.enums.BinlogClientMode;
import com.gitee.Jmysy.binlog4j.core.position.BinlogPositionHandler;
import com.gitee.Jmysy.binlog4j.core.utils.MD5Utils;
import java.util.concurrent.TimeUnit;

public class BinlogClientConfig {
    private String username;
    private String password;
    private String host;
    private int port = 3306;
    private long timeOffset = 0L;
    private long serverId;
    private boolean keepAlive = true;
    private boolean inaugural = false;
    private long keepAliveInterval = TimeUnit.MINUTES.toMillis(1L);
    private long connectTimeout = TimeUnit.SECONDS.toMillis(3L);
    private long heartbeatInterval = TimeUnit.SECONDS.toMillis(6L);
    private RedisConfig redisConfig;
    private boolean persistence = false;
    private BinlogClientMode mode = BinlogClientMode.standalone;
    private BinlogPositionHandler positionHandler;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getServerId() {
        return this.serverId;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public long getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(long keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public RedisConfig getRedisConfig() {
        return this.redisConfig;
    }

    public void setRedisConfig(RedisConfig redisConfig) {
        this.redisConfig = redisConfig;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Boolean getPersistence() {
        return this.persistence;
    }

    public void setPersistence(Boolean persistence) {
        this.persistence = persistence;
    }

    public BinlogClientMode getMode() {
        return this.mode;
    }

    public void setMode(BinlogClientMode mode) {
        this.mode = mode;
    }

    public String getKey() {
        return MD5Utils.encrypt(this.host + ":" + this.port + ":" + this.serverId);
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(long timeOffset) {
        this.timeOffset = timeOffset;
    }

    public boolean isInaugural() {
        return this.inaugural;
    }

    public void setInaugural(boolean inaugural) {
        this.inaugural = inaugural;
    }

    public BinlogPositionHandler getPositionHandler() {
        return this.positionHandler;
    }

    public void setPositionHandler(BinlogPositionHandler positionHandler) {
        this.positionHandler = positionHandler;
    }
}

