/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.Jmysy.binlog4j.core;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import com.gitee.Jmysy.binlog4j.core.BinlogClientConfig;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import com.gitee.Jmysy.binlog4j.core.meta.ColumnMetadata;
import com.gitee.Jmysy.binlog4j.core.utils.ClassUtils;
import com.gitee.Jmysy.binlog4j.core.utils.JDBCUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BinlogEventHandlerInvoker<T> {
    private IBinlogEventHandler eventHandler;
    private BinlogClientConfig clientConfig;
    private Class<T> genericClass;
    private static final ParserConfig SNAKE_CASE = new ParserConfig();

    public void invokeInsert(String databaseName, String tableName, List<Serializable[]> data) {
        List<ColumnMetadata> columns = this.getColumns(databaseName, tableName);
        data.forEach(row -> {
            BinlogEvent<T> binlogEvent = new BinlogEvent<T>();
            binlogEvent.setDatabase(databaseName);
            binlogEvent.setTable(tableName);
            binlogEvent.setData(this.toEntity(columns, (Serializable[])row));
            binlogEvent.setTimestamp(System.currentTimeMillis());
            if (this.eventHandler.isHandle(binlogEvent)) {
                this.eventHandler.onInsert(binlogEvent);
            }
        });
    }

    public void invokeUpdate(String databaseName, String tableName, List<Map.Entry<Serializable[], Serializable[]>> data) {
        List<ColumnMetadata> columns = this.getColumns(databaseName, tableName);
        data.forEach(row -> {
            BinlogEvent<T> binlogEvent = new BinlogEvent<T>();
            binlogEvent.setDatabase(databaseName);
            binlogEvent.setTable(tableName);
            binlogEvent.setData(this.toEntity(columns, (Serializable[])row.getValue()));
            binlogEvent.setOriginalData(this.toEntity(columns, (Serializable[])row.getKey()));
            binlogEvent.setTimestamp(System.currentTimeMillis());
            if (this.eventHandler.isHandle(binlogEvent)) {
                this.eventHandler.onUpdate(binlogEvent);
            }
        });
    }

    public void invokeDelete(String databaseName, String tableName, List<Serializable[]> data) {
        List<ColumnMetadata> columns = this.getColumns(databaseName, tableName);
        data.forEach(row -> {
            BinlogEvent<T> binlogEvent = new BinlogEvent<T>();
            binlogEvent.setDatabase(databaseName);
            binlogEvent.setTable(tableName);
            binlogEvent.setData(this.toEntity(columns, (Serializable[])row));
            binlogEvent.setTimestamp(System.currentTimeMillis());
            if (this.eventHandler.isHandle(binlogEvent)) {
                this.eventHandler.onDelete(binlogEvent);
            }
        });
    }

    public List<ColumnMetadata> getColumns(String databaseName, String tableName) {
        return JDBCUtils.getColumnNames(this.clientConfig, databaseName, tableName);
    }

    public T toEntity(List<ColumnMetadata> columnNames, Serializable[] data) {
        HashMap<String, Serializable> obj = new HashMap<String, Serializable>(columnNames.size());
        for (int i = 0; i < data.length; ++i) {
            Field field;
            ColumnMetadata column = columnNames.get(i);
            Serializable fieldValue = data[i];
            if (fieldValue instanceof java.sql.Date) {
                if (fieldValue != null) {
                    data[i] = new Date(((Date)fieldValue).getTime() + this.clientConfig.getTimeOffset());
                }
            } else if (fieldValue instanceof byte[]) {
                if (fieldValue != null && this.genericClass != null && (field = ClassUtils.getDeclaredField(this.genericClass, column.getColumnName())) != null && field.getType() == String.class) {
                    data[i] = new String((byte[])fieldValue, StandardCharsets.UTF_8);
                }
            } else if (fieldValue instanceof BitSet && fieldValue != null && this.genericClass != null && (field = ClassUtils.getDeclaredField(this.genericClass, column.getColumnName())) != null && (field.getType() == Boolean.class || field.getType() == Boolean.TYPE)) {
                data[i] = Boolean.valueOf(!((BitSet)fieldValue).isEmpty());
            }
            obj.put(column.getColumnName(), data[i]);
        }
        if (this.genericClass != null) {
            return (T)TypeUtils.cast(obj, this.genericClass, (ParserConfig)SNAKE_CASE);
        }
        return (T)obj;
    }

    public void setEventHandler(IBinlogEventHandler eventHandler) {
        this.eventHandler = eventHandler;
        this.genericClass = ClassUtils.getGenericType(eventHandler.getClass());
    }

    public IBinlogEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public BinlogClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public Class<T> getGenericClass() {
        return this.genericClass;
    }

    public void setClientConfig(BinlogClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public void setGenericClass(Class<T> genericClass) {
        this.genericClass = genericClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinlogEventHandlerInvoker)) {
            return false;
        }
        BinlogEventHandlerInvoker other = (BinlogEventHandlerInvoker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IBinlogEventHandler this$eventHandler = this.getEventHandler();
        IBinlogEventHandler other$eventHandler = other.getEventHandler();
        if (this$eventHandler == null ? other$eventHandler != null : !this$eventHandler.equals(other$eventHandler)) {
            return false;
        }
        BinlogClientConfig this$clientConfig = this.getClientConfig();
        BinlogClientConfig other$clientConfig = other.getClientConfig();
        if (this$clientConfig == null ? other$clientConfig != null : !this$clientConfig.equals(other$clientConfig)) {
            return false;
        }
        Class<T> this$genericClass = this.getGenericClass();
        Class<T> other$genericClass = other.getGenericClass();
        return !(this$genericClass == null ? other$genericClass != null : !this$genericClass.equals(other$genericClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BinlogEventHandlerInvoker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IBinlogEventHandler $eventHandler = this.getEventHandler();
        result = result * 59 + ($eventHandler == null ? 43 : $eventHandler.hashCode());
        BinlogClientConfig $clientConfig = this.getClientConfig();
        result = result * 59 + ($clientConfig == null ? 43 : $clientConfig.hashCode());
        Class<T> $genericClass = this.getGenericClass();
        result = result * 59 + ($genericClass == null ? 43 : $genericClass.hashCode());
        return result;
    }

    public String toString() {
        return "BinlogEventHandlerInvoker(eventHandler=" + this.getEventHandler() + ", clientConfig=" + this.getClientConfig() + ", genericClass=" + this.getGenericClass() + ")";
    }

    static {
        BinlogEventHandlerInvoker.SNAKE_CASE.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

