/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.Jmysy.binlog4j.core.position;

import com.alibaba.fastjson.JSON;
import com.gitee.Jmysy.binlog4j.core.config.RedisConfig;
import com.gitee.Jmysy.binlog4j.core.position.BinlogPosition;
import com.gitee.Jmysy.binlog4j.core.position.BinlogPositionHandler;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisBinlogPositionHandler
implements BinlogPositionHandler {
    private final JedisPool jedisPool;

    public RedisBinlogPositionHandler(RedisConfig redisConfig) {
        this.jedisPool = new JedisPool(new GenericObjectPoolConfig(), redisConfig.getHost(), redisConfig.getPort(), 1000, redisConfig.getPassword(), redisConfig.getDatabase());
    }

    @Override
    public BinlogPosition loadPosition(Long serverId) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String value = jedis.get(serverId.toString());
            if (value != null) {
                BinlogPosition binlogPosition = (BinlogPosition)JSON.parseObject((String)value, BinlogPosition.class);
                return binlogPosition;
            }
        }
        return null;
    }

    @Override
    public void savePosition(BinlogPosition position) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.set(position.getServerId().toString(), JSON.toJSONString((Object)position));
        }
    }
}

