/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.Jmysy.binlog4j.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ClassUtils {
    public static <T> Class<T> getGenericType(Class<?> cls) {
        ParameterizedType paramType;
        Type[] argTypes;
        Type type;
        Type superclass = cls.getGenericSuperclass();
        Type[] genericInterfaces = cls.getGenericInterfaces();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType paramType2 = (ParameterizedType)superclass;
            Type[] argTypes2 = paramType2.getActualTypeArguments();
            if (argTypes2.length > 0) {
                return (Class)argTypes2[0];
            }
        } else if (genericInterfaces.length > 0 && (type = genericInterfaces[0]) instanceof ParameterizedType && (argTypes = (paramType = (ParameterizedType)type).getActualTypeArguments()).length > 0) {
            return (Class)argTypes[0];
        }
        return null;
    }

    public static Field getDeclaredField(Class clazz, String fieldName) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(ClassUtils.toCamel(fieldName, "_")) && !field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static String toCamel(String str, String ch) {
        if (str.indexOf(ch) == -1) {
            return str;
        }
        String[] strings = str.split(ch);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            if (i == 0) {
                stringBuffer.append(strings[i].toLowerCase());
                continue;
            }
            stringBuffer.append(strings[i].substring(0, 1).toUpperCase()).append(strings[i].substring(1).toLowerCase());
        }
        return stringBuffer.toString();
    }
}

