/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.Jmysy.binlog4j.core.utils;

import com.gitee.Jmysy.binlog4j.core.BinlogClientConfig;
import com.gitee.Jmysy.binlog4j.core.meta.ColumnMetadata;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class JDBCUtils {
    private static ConcurrentHashMap<Long, DataSource> dataSourceMap = new ConcurrentHashMap();

    public static HikariDataSource createDataSource(BinlogClientConfig dataSourceProperties) {
        HikariConfig hikariConfig = new HikariConfig();
        String serverAddress = dataSourceProperties.getHost() + ":" + dataSourceProperties.getPort();
        hikariConfig.setJdbcUrl("jdbc:mysql://" + serverAddress + "/INFORMATION_SCHEMA?useUnicode=true&characterEncoding=UTF-8&useSSL=false");
        hikariConfig.setUsername(dataSourceProperties.getUsername());
        hikariConfig.setPassword(dataSourceProperties.getPassword());
        hikariConfig.setMaximumPoolSize(20);
        return new HikariDataSource(hikariConfig);
    }

    public static DataSource getDataSource(BinlogClientConfig dataSourceProperties) {
        Long serverId = dataSourceProperties.getServerId();
        return dataSourceMap.computeIfAbsent(serverId, key -> JDBCUtils.createDataSource(dataSourceProperties));
    }

    public static Connection getConnection(BinlogClientConfig dataSourceProperties) throws SQLException {
        DataSource dataSource = JDBCUtils.getDataSource(dataSourceProperties);
        return dataSource.getConnection();
    }

    public static List<ColumnMetadata> parseResultSet(ResultSet resultSet) {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        while (resultSet.next()) {
            ColumnMetadata column = new ColumnMetadata();
            column.setColumnName(resultSet.getString("COLUMN_NAME"));
            column.setDataType(resultSet.getString("DATA_TYPE"));
            column.setCharacterSetName(resultSet.getString("CHARACTER_SET_NAME"));
            columns.add(column);
        }
        return columns;
    }

    /*
     * Exception decompiling
     */
    public static List<ColumnMetadata> getColumnNames(BinlogClientConfig dataSourceProperties, String database, String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

