/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.Jmysy.binlog4j.core;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import com.gitee.Jmysy.binlog4j.core.BinlogClientConfig;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import com.gitee.Jmysy.binlog4j.core.meta.ColumnMetadata;
import com.gitee.Jmysy.binlog4j.core.utils.ClassUtils;
import com.gitee.Jmysy.binlog4j.core.utils.JDBCUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BinlogEventHandlerInvoker<T> {
    private Map<String, List<ColumnMetadata>> columnMetadataMap = new HashMap<String, List<ColumnMetadata>>();
    private IBinlogEventHandler eventHandler;
    private BinlogClientConfig clientConfig;
    private Class<T> genericClass;
    private static final ParserConfig SNAKE_CASE = new ParserConfig();

    public void invokeInsert(String databaseName, String tableName, List<Serializable[]> data) {
        if (this.eventHandler.isHandle(databaseName, tableName)) {
            List<ColumnMetadata> columns = this.getColumns(databaseName, tableName);
            BinlogEvent binlogEvent = this.createBinlogEvent(databaseName, tableName);
            data.forEach(row -> {
                binlogEvent.setData(this.toEntity(columns, (Serializable[])row));
                this.eventHandler.onInsert(binlogEvent);
            });
        }
    }

    public void invokeUpdate(String databaseName, String tableName, List<Map.Entry<Serializable[], Serializable[]>> data) {
        if (this.eventHandler.isHandle(databaseName, tableName)) {
            List<ColumnMetadata> columns = this.getColumns(databaseName, tableName);
            BinlogEvent binlogEvent = this.createBinlogEvent(databaseName, tableName);
            data.forEach(row -> {
                binlogEvent.setData(this.toEntity(columns, (Serializable[])row.getValue()));
                binlogEvent.setOriginalData(this.toEntity(columns, (Serializable[])row.getKey()));
                this.eventHandler.onUpdate(binlogEvent);
            });
        }
    }

    public void invokeDelete(String databaseName, String tableName, List<Serializable[]> data) {
        if (this.eventHandler.isHandle(databaseName, tableName)) {
            List<ColumnMetadata> columns = this.getColumns(databaseName, tableName);
            BinlogEvent binlogEvent = this.createBinlogEvent(databaseName, tableName);
            data.forEach(row -> {
                binlogEvent.setData(this.toEntity(columns, (Serializable[])row));
                this.eventHandler.onDelete(binlogEvent);
            });
        }
    }

    private BinlogEvent createBinlogEvent(String databaseName, String tableName) {
        BinlogEvent binlogEvent = new BinlogEvent();
        binlogEvent.setDatabase(databaseName);
        binlogEvent.setTable(tableName);
        binlogEvent.setTimestamp(System.currentTimeMillis());
        return binlogEvent;
    }

    public List<ColumnMetadata> getColumns(String databaseName, String tableName) {
        String tableSchema = String.format("%s.%s", databaseName, tableName);
        List<ColumnMetadata> columns = this.columnMetadataMap.get(tableSchema);
        if (columns == null || this.clientConfig.isStrict()) {
            columns = JDBCUtils.getColumns(this.clientConfig, databaseName, tableName);
            this.columnMetadataMap.put(tableSchema, columns);
        }
        return columns;
    }

    public T toEntity(List<ColumnMetadata> columns, Serializable[] data) {
        HashMap<String, Serializable> obj = new HashMap<String, Serializable>(columns.size());
        for (int i = 0; i < data.length; ++i) {
            Field field;
            ColumnMetadata column = columns.get(i);
            Serializable fieldValue = data[i];
            if (fieldValue instanceof Date) {
                if (fieldValue != null) {
                    data[i] = new Date(((Date)fieldValue).getTime() + this.clientConfig.getTimeOffset());
                }
            } else if (fieldValue instanceof byte[]) {
                if (fieldValue != null && this.genericClass != null && (field = ClassUtils.getDeclaredField(this.genericClass, column.getColumnName())) != null && field.getType() == String.class) {
                    data[i] = new String((byte[])fieldValue, StandardCharsets.UTF_8);
                }
            } else if (fieldValue instanceof BitSet && fieldValue != null && this.genericClass != null && (field = ClassUtils.getDeclaredField(this.genericClass, column.getColumnName())) != null && (field.getType() == Boolean.class || field.getType() == Boolean.TYPE)) {
                data[i] = Boolean.valueOf(!((BitSet)fieldValue).isEmpty());
            }
            obj.put(column.getColumnName(), data[i]);
        }
        if (this.genericClass != null) {
            return (T)TypeUtils.cast(obj, this.genericClass, (ParserConfig)SNAKE_CASE);
        }
        return (T)obj;
    }

    public void setEventHandler(IBinlogEventHandler eventHandler) {
        this.eventHandler = eventHandler;
        this.genericClass = ClassUtils.getGenericType(eventHandler.getClass());
    }

    public Map<String, List<ColumnMetadata>> getColumnMetadataMap() {
        return this.columnMetadataMap;
    }

    public IBinlogEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public BinlogClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public Class<T> getGenericClass() {
        return this.genericClass;
    }

    public void setColumnMetadataMap(Map<String, List<ColumnMetadata>> columnMetadataMap) {
        this.columnMetadataMap = columnMetadataMap;
    }

    public void setClientConfig(BinlogClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public void setGenericClass(Class<T> genericClass) {
        this.genericClass = genericClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinlogEventHandlerInvoker)) {
            return false;
        }
        BinlogEventHandlerInvoker other = (BinlogEventHandlerInvoker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<ColumnMetadata>> this$columnMetadataMap = this.getColumnMetadataMap();
        Map<String, List<ColumnMetadata>> other$columnMetadataMap = other.getColumnMetadataMap();
        if (this$columnMetadataMap == null ? other$columnMetadataMap != null : !((Object)this$columnMetadataMap).equals(other$columnMetadataMap)) {
            return false;
        }
        IBinlogEventHandler this$eventHandler = this.getEventHandler();
        IBinlogEventHandler other$eventHandler = other.getEventHandler();
        if (this$eventHandler == null ? other$eventHandler != null : !this$eventHandler.equals(other$eventHandler)) {
            return false;
        }
        BinlogClientConfig this$clientConfig = this.getClientConfig();
        BinlogClientConfig other$clientConfig = other.getClientConfig();
        if (this$clientConfig == null ? other$clientConfig != null : !this$clientConfig.equals(other$clientConfig)) {
            return false;
        }
        Class<T> this$genericClass = this.getGenericClass();
        Class<T> other$genericClass = other.getGenericClass();
        return !(this$genericClass == null ? other$genericClass != null : !this$genericClass.equals(other$genericClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BinlogEventHandlerInvoker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<ColumnMetadata>> $columnMetadataMap = this.getColumnMetadataMap();
        result = result * 59 + ($columnMetadataMap == null ? 43 : ((Object)$columnMetadataMap).hashCode());
        IBinlogEventHandler $eventHandler = this.getEventHandler();
        result = result * 59 + ($eventHandler == null ? 43 : $eventHandler.hashCode());
        BinlogClientConfig $clientConfig = this.getClientConfig();
        result = result * 59 + ($clientConfig == null ? 43 : $clientConfig.hashCode());
        Class<T> $genericClass = this.getGenericClass();
        result = result * 59 + ($genericClass == null ? 43 : $genericClass.hashCode());
        return result;
    }

    public String toString() {
        return "BinlogEventHandlerInvoker(columnMetadataMap=" + this.getColumnMetadataMap() + ", eventHandler=" + this.getEventHandler() + ", clientConfig=" + this.getClientConfig() + ", genericClass=" + this.getGenericClass() + ")";
    }

    static {
        BinlogEventHandlerInvoker.SNAKE_CASE.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

