/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.Jmysy.binlog4j.core.dispatcher;

import com.gitee.Jmysy.binlog4j.core.BinlogClientConfig;
import com.gitee.Jmysy.binlog4j.core.BinlogEventHandlerInvoker;
import com.gitee.Jmysy.binlog4j.core.position.BinlogPosition;
import com.gitee.Jmysy.binlog4j.core.position.BinlogPositionHandler;
import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.event.DeleteRowsEventData;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.UpdateRowsEventData;
import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BinlogEventDispatcher
implements BinaryLogClient.EventListener {
    private final Map<Long, TableMapEventData> tableMap = new HashMap<Long, TableMapEventData>();
    private final Map<String, BinlogEventHandlerInvoker> eventHandlerMap;
    private final BinlogClientConfig clientConfig;
    private final BinlogPositionHandler binlogPositionHandler;

    public BinlogEventDispatcher(BinlogClientConfig clientConfig, BinlogPositionHandler positionHandler, Map<String, BinlogEventHandlerInvoker> eventHandlerMap) {
        this.clientConfig = clientConfig;
        this.eventHandlerMap = eventHandlerMap;
        this.binlogPositionHandler = positionHandler;
    }

    public void onEvent(Event event) {
        RowMutationEventData rowMutationEventData;
        TableMapEventData tableMapEventData;
        EventHeaderV4 headerV4 = (EventHeaderV4)event.getHeader();
        EventType eventType = headerV4.getEventType();
        if (eventType == EventType.TABLE_MAP) {
            TableMapEventData eventData = (TableMapEventData)event.getData();
            this.tableMap.put(eventData.getTableId(), eventData);
        } else if (EventType.isRowMutation((EventType)eventType) && (tableMapEventData = this.tableMap.get((rowMutationEventData = new RowMutationEventData(event.getData())).getTableId())) != null) {
            String database = tableMapEventData.getDatabase();
            String table = tableMapEventData.getTable();
            this.eventHandlerMap.forEach((handlerKey, eventHandler) -> {
                if (EventType.isUpdate((EventType)eventType)) {
                    eventHandler.invokeUpdate(database, table, rowMutationEventData.getUpdateRows());
                    return;
                }
                if (EventType.isDelete((EventType)eventType)) {
                    eventHandler.invokeDelete(database, table, rowMutationEventData.getDeleteRows());
                    return;
                }
                if (EventType.isWrite((EventType)eventType)) {
                    eventHandler.invokeInsert(database, table, rowMutationEventData.getInsertRows());
                }
            });
        }
        if (this.clientConfig.getPersistence().booleanValue() && this.binlogPositionHandler != null && eventType != EventType.FORMAT_DESCRIPTION) {
            BinlogPosition binlogPosition = new BinlogPosition();
            if (EventType.ROTATE == eventType) {
                binlogPosition.setServerId(this.clientConfig.getServerId());
                binlogPosition.setFilename(((RotateEventData)event.getData()).getBinlogFilename());
                binlogPosition.setPosition(((RotateEventData)event.getData()).getBinlogPosition());
            } else {
                binlogPosition = this.binlogPositionHandler.loadPosition(this.clientConfig.getServerId());
                if (binlogPosition != null) {
                    binlogPosition.setPosition(headerV4.getNextPosition());
                }
            }
            this.binlogPositionHandler.savePosition(binlogPosition);
        }
    }

    public static class RowMutationEventData {
        private long tableId;
        private List<Serializable[]> insertRows;
        private List<Serializable[]> deleteRows;
        private List<Map.Entry<Serializable[], Serializable[]>> updateRows;

        public RowMutationEventData(EventData eventData) {
            if (eventData instanceof UpdateRowsEventData) {
                UpdateRowsEventData updateRowsEventData = (UpdateRowsEventData)eventData;
                this.tableId = updateRowsEventData.getTableId();
                this.updateRows = updateRowsEventData.getRows();
                return;
            }
            if (eventData instanceof WriteRowsEventData) {
                WriteRowsEventData writeRowsEventData = (WriteRowsEventData)eventData;
                this.tableId = writeRowsEventData.getTableId();
                this.insertRows = writeRowsEventData.getRows();
                return;
            }
            if (eventData instanceof DeleteRowsEventData) {
                DeleteRowsEventData deleteRowsEventData = (DeleteRowsEventData)eventData;
                this.tableId = deleteRowsEventData.getTableId();
                this.deleteRows = deleteRowsEventData.getRows();
            }
        }

        public long getTableId() {
            return this.tableId;
        }

        public List<Serializable[]> getInsertRows() {
            return this.insertRows;
        }

        public List<Serializable[]> getDeleteRows() {
            return this.deleteRows;
        }

        public List<Map.Entry<Serializable[], Serializable[]>> getUpdateRows() {
            return this.updateRows;
        }

        public void setTableId(long tableId) {
            this.tableId = tableId;
        }

        public void setInsertRows(List<Serializable[]> insertRows) {
            this.insertRows = insertRows;
        }

        public void setDeleteRows(List<Serializable[]> deleteRows) {
            this.deleteRows = deleteRows;
        }

        public void setUpdateRows(List<Map.Entry<Serializable[], Serializable[]>> updateRows) {
            this.updateRows = updateRows;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RowMutationEventData)) {
                return false;
            }
            RowMutationEventData other = (RowMutationEventData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTableId() != other.getTableId()) {
                return false;
            }
            List<Serializable[]> this$insertRows = this.getInsertRows();
            List<Serializable[]> other$insertRows = other.getInsertRows();
            if (this$insertRows == null ? other$insertRows != null : !((Object)this$insertRows).equals(other$insertRows)) {
                return false;
            }
            List<Serializable[]> this$deleteRows = this.getDeleteRows();
            List<Serializable[]> other$deleteRows = other.getDeleteRows();
            if (this$deleteRows == null ? other$deleteRows != null : !((Object)this$deleteRows).equals(other$deleteRows)) {
                return false;
            }
            List<Map.Entry<Serializable[], Serializable[]>> this$updateRows = this.getUpdateRows();
            List<Map.Entry<Serializable[], Serializable[]>> other$updateRows = other.getUpdateRows();
            return !(this$updateRows == null ? other$updateRows != null : !((Object)this$updateRows).equals(other$updateRows));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RowMutationEventData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $tableId = this.getTableId();
            result = result * 59 + (int)($tableId >>> 32 ^ $tableId);
            List<Serializable[]> $insertRows = this.getInsertRows();
            result = result * 59 + ($insertRows == null ? 43 : ((Object)$insertRows).hashCode());
            List<Serializable[]> $deleteRows = this.getDeleteRows();
            result = result * 59 + ($deleteRows == null ? 43 : ((Object)$deleteRows).hashCode());
            List<Map.Entry<Serializable[], Serializable[]>> $updateRows = this.getUpdateRows();
            result = result * 59 + ($updateRows == null ? 43 : ((Object)$updateRows).hashCode());
            return result;
        }

        public String toString() {
            return "BinlogEventDispatcher.RowMutationEventData(tableId=" + this.getTableId() + ", insertRows=" + this.getInsertRows() + ", deleteRows=" + this.getDeleteRows() + ", updateRows=" + this.getUpdateRows() + ")";
        }
    }
}

