/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.cqdevops.desensitization.pattern;

import com.gitee.cqdevops.desensitization.pattern.BaseConverter;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KeywordConverter
extends BaseConverter {
    private static Pattern pattern = Pattern.compile("[0-9a-zA-Z]");

    @Override
    public String invokeMsg(String oriMsg) {
        String tempMsg = oriMsg;
        try {
            if ("true".equals(this.converterCanRun) && !keywordMap.isEmpty()) {
                Set keysArray = keywordMap.keySet();
                for (String key : keysArray) {
                    int index = -1;
                    int i = 0;
                    do {
                        if ((index = tempMsg.indexOf(key, index + 1)) == -1 || this.isWordChar(tempMsg, key, index)) continue;
                        int valueStart = this.getValueStartIndex(tempMsg, index + key.length());
                        int valueEnd = this.getValueEndEIndex(tempMsg, valueStart);
                        String subStr = tempMsg.substring(valueStart, valueEnd);
                        subStr = this.facade(subStr, (String)keywordMap.get(key));
                        tempMsg = tempMsg.substring(0, valueStart) + subStr + tempMsg.substring(valueEnd);
                        ++i;
                    } while (index != -1 && i < this.depth);
                }
            }
        }
        catch (Exception e) {
            return tempMsg;
        }
        return tempMsg;
    }

    private boolean isWordChar(String msg, String key, int index) {
        char preCh;
        Matcher match;
        if (index != 0 && (match = pattern.matcher((preCh = msg.charAt(index - 1)) + "")).matches()) {
            return true;
        }
        char nextCh = msg.charAt(index + key.length());
        match = pattern.matcher(nextCh + "");
        return match.matches();
    }

    private int getValueStartIndex(String msg, int valueStart) {
        while (true) {
            char ch;
            if ((ch = msg.charAt(valueStart)) == ':' || ch == '=') {
                if ((ch = msg.charAt(++valueStart)) != '\"') break;
                ++valueStart;
                break;
            }
            ++valueStart;
        }
        return valueStart;
    }

    private int getValueEndEIndex(String msg, int valueEnd) {
        while (valueEnd != msg.length()) {
            char ch = msg.charAt(valueEnd);
            if (ch == '\"') {
                if (valueEnd + 1 == msg.length()) break;
                char nextCh = msg.charAt(valueEnd + 1);
                if (nextCh == ';' || nextCh == ',' || nextCh == '}') {
                    char preCh;
                    while (valueEnd > 0 && (preCh = msg.charAt(valueEnd - 1)) == '\\') {
                        --valueEnd;
                    }
                    break;
                }
                ++valueEnd;
                continue;
            }
            if (ch == ';' || ch == ',' || ch == '}') break;
            ++valueEnd;
        }
        return valueEnd;
    }
}

