/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.cqdevops.desensitization.encoder;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import java.text.MessageFormat;

public class CommonPatternLayoutEncoder
extends PatternLayoutEncoder {
    protected static final String PATTERN_D1 = "%d{yyyy-MM-dd HH:mm:ss.SSS} [%thread]";
    protected static final String PATTERN_D2 = " [{0}:%X'{'{1}'}']";
    protected static final String PATTERN_D3_S1 = " [%level] %logger{10}-%L ";
    protected static final String PATTERN_D3_S2 = "%msg'{'{0},{1},{2},{3}'}'%n";
    protected String converterCanRun = "false";
    protected String sensitiveData;
    protected String mdcKeys;
    protected int depth = 12;
    protected int maxLength = 2048;

    public void start() {
        if (this.getPattern() == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(PATTERN_D1);
            if (this.mdcKeys != null) {
                String[] keys;
                for (String key : keys = this.mdcKeys.split(",")) {
                    sb.append(MessageFormat.format(PATTERN_D2, key, key));
                }
            }
            sb.append(PATTERN_D3_S1);
            if (this.maxLength < 0 || this.maxLength > 10240) {
                this.maxLength = 2048;
            }
            sb.append(MessageFormat.format(PATTERN_D3_S2, this.converterCanRun, String.valueOf(this.depth), String.valueOf(this.maxLength), this.sensitiveData));
            this.setPattern(sb.toString());
        }
        super.start();
    }

    public String getSensitiveData() {
        return this.sensitiveData;
    }

    public void setSensitiveData(String sensitiveData) {
        this.sensitiveData = sensitiveData;
    }

    public String getConverterCanRun() {
        return this.converterCanRun;
    }

    public void setConverterCanRun(String converterCanRun) {
        this.converterCanRun = converterCanRun;
    }

    public String getMdcKeys() {
        return this.mdcKeys;
    }

    public void setMdcKeys(String mdcKeys) {
        this.mdcKeys = mdcKeys;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String getPattern() {
        return super.getPattern();
    }

    public void setPattern(String pattern) {
        super.setPattern(pattern);
    }
}

