/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.cqdevops.desensitization.pattern;

import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.gitee.cqdevops.desensitization.enums.KeywordTypeEnum;
import com.gitee.cqdevops.desensitization.util.SensitiveInfoUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseConverter
extends MessageConverter {
    protected String converterCanRun = "false";
    protected Integer depth = 12;
    protected Integer maxLength = 2048;
    protected static Map<String, String> keywordMap = new HashMap<String, String>();

    public void start() {
        List options = this.getOptionList();
        if (options != null && options.size() >= 3) {
            this.converterCanRun = String.valueOf(options.get(0));
            this.depth = Integer.valueOf((String)options.get(1));
            this.maxLength = Integer.valueOf((String)options.get(2));
            if (options.size() > 3) {
                for (int i = 3; i < options.size(); ++i) {
                    String[] keywordArray;
                    String keywordType;
                    KeywordTypeEnum keywordTypeEnum;
                    String[] sensitiveArray;
                    String sensitiveData = String.valueOf(options.get(i));
                    if (StringUtils.isEmpty((CharSequence)sensitiveData) || (sensitiveArray = sensitiveData.split(":")).length != 2 || (keywordTypeEnum = KeywordTypeEnum.getMessageType(keywordType = sensitiveArray[0])) == null || StringUtils.isEmpty((CharSequence)sensitiveArray[1]) || (keywordArray = sensitiveArray[1].split(";")).length <= 0) continue;
                    for (String keyword : keywordArray) {
                        keywordMap.put(keyword, keywordType);
                    }
                }
            }
        }
        super.start();
    }

    public String convert(ILoggingEvent event) {
        String oriLogMsg = event.getFormattedMessage();
        if (oriLogMsg == null || oriLogMsg.isEmpty()) {
            return oriLogMsg;
        }
        if (oriLogMsg.length() > this.maxLength) {
            oriLogMsg = oriLogMsg.substring(0, this.maxLength) + "<<<";
        }
        return this.invokeMsg(oriLogMsg);
    }

    protected String facade(String msg, String key) {
        String result = msg;
        KeywordTypeEnum keywordTypeEnum = KeywordTypeEnum.getMessageType(key);
        if (keywordTypeEnum == null) {
            keywordTypeEnum = KeywordTypeEnum.OTHER;
        }
        switch (keywordTypeEnum) {
            case TRUE_NAME: {
                result = SensitiveInfoUtils.handleTrueName(msg);
                break;
            }
            case ID_CARD_NO: {
                result = SensitiveInfoUtils.handleIdCardNo(msg);
                break;
            }
            case BANKCARD_NO: {
                result = SensitiveInfoUtils.handleBankcardNo(msg);
                break;
            }
            case PHONE_NO: {
                result = SensitiveInfoUtils.handlePhoneNo(msg);
                break;
            }
            case OTHER: {
                result = SensitiveInfoUtils.handleOther(msg);
            }
        }
        return result;
    }

    public abstract String invokeMsg(String var1);
}

