/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.dsl.factory.support;

import com.gitee.hengboy.mybatis.enhance.common.helper.StatementHelper;
import com.gitee.hengboy.mybatis.enhance.dsl.delete.Deleteable;
import com.gitee.hengboy.mybatis.enhance.dsl.factory.EnhanceDsl;
import com.gitee.hengboy.mybatis.enhance.dsl.result.ReloadResultFactory;
import com.gitee.hengboy.mybatis.enhance.dsl.serach.Searchable;
import com.gitee.hengboy.mybatis.enhance.dsl.update.Updateable;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

public class EnhanceDslSupport
implements EnhanceDsl {
    private SqlSession sqlSession;

    public EnhanceDslSupport(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    @Override
    public <T> List<T> select(Searchable searchable) throws EnhanceFrameworkException {
        MappedStatement statement = StatementHelper.createOrGetDslStatement((Configuration)this.sqlSession.getConfiguration(), (String)searchable.getSql(), (Map)searchable.getParams(), (SqlCommandType)SqlCommandType.SELECT);
        ReloadResultFactory.newInstance(searchable.getResultType()).reload(statement);
        return this.sqlSession.selectList(statement.getId(), (Object)searchable.getParams());
    }

    @Override
    public <T> T selectOne(Searchable searchable) throws EnhanceFrameworkException {
        MappedStatement statement = StatementHelper.createOrGetDslStatement((Configuration)this.sqlSession.getConfiguration(), (String)searchable.getSql(), (Map)searchable.getParams(), (SqlCommandType)SqlCommandType.SELECT);
        ReloadResultFactory.newInstance(searchable.getResultType()).reload(statement);
        return (T)this.sqlSession.selectOne(statement.getId(), (Object)searchable.getParams());
    }

    @Override
    public void delete(Deleteable deleteable) throws EnhanceFrameworkException {
        MappedStatement statement = StatementHelper.createOrGetDslStatement((Configuration)this.sqlSession.getConfiguration(), (String)deleteable.getSql(), (Map)deleteable.getParams(), (SqlCommandType)SqlCommandType.DELETE);
        this.sqlSession.delete(statement.getId(), (Object)deleteable.getParams());
    }

    @Override
    public void update(Updateable updateable) throws EnhanceFrameworkException {
        MappedStatement statement = StatementHelper.createOrGetDslStatement((Configuration)this.sqlSession.getConfiguration(), (String)updateable.getSql(), (Map)updateable.getParams(), (SqlCommandType)SqlCommandType.UPDATE);
        this.sqlSession.delete(statement.getId(), (Object)updateable.getParams());
    }
}

