/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.dsl.serach.support;

import com.gitee.hengboy.mybatis.enhance.common.enums.PlaceholderEnum;
import com.gitee.hengboy.mybatis.enhance.dsl.expression.ColumnExpression;
import com.gitee.hengboy.mybatis.enhance.dsl.expression.TableExpression;
import com.gitee.hengboy.mybatis.enhance.dsl.factory.EnhanceDsl;
import com.gitee.hengboy.mybatis.enhance.dsl.serach.Searchable;
import com.gitee.hengboy.mybatis.enhance.dsl.where.support.WhereableSupport;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import com.gitee.hengboy.mybatis.enhance.sort.SortEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class SearchableSupport
extends WhereableSupport
implements Searchable {
    private Class<?> resultType;
    private int offset;
    private int limit;
    private boolean distinct = false;
    private EnhanceDsl enhanceDsl;
    private List<ColumnExpression> selectColumns = new ArrayList<ColumnExpression>();
    private Map<String, String> selectSQLColumns = new HashMap<String, String>();
    private List<ColumnExpression> functionColumns = new ArrayList<ColumnExpression>();

    public SearchableSupport(EnhanceDsl enhanceDsl) {
        this.enhanceDsl = enhanceDsl;
    }

    @Override
    public Searchable select(ColumnExpression ... columnExpressions) {
        for (ColumnExpression columnExpression : columnExpressions) {
            if (this.checkHaveFunction(columnExpression)) {
                this.functionColumns.add(columnExpression);
                continue;
            }
            this.selectColumns.add(columnExpression);
        }
        return this;
    }

    @Override
    public Searchable SQLColumn(String sql, String asName) throws EnhanceFrameworkException {
        this.selectSQLColumns.put(asName, sql);
        return this;
    }

    @Override
    public Searchable select(TableExpression tableExpression) {
        this.select(tableExpression.getColumns());
        return this;
    }

    @Override
    public Searchable selectFrom(TableExpression tableExpression) throws EnhanceFrameworkException {
        this.select(tableExpression);
        this.from(tableExpression);
        return this;
    }

    @Override
    public Searchable from(TableExpression ... tableExpressions) {
        TableExpression tableExpression = tableExpressions[0];
        this.checkTableAlias(tableExpression);
        this.sql.FROM(tableExpression.getRoot() + "\n" + (!StringUtils.isEmpty((Object)tableExpression.getAsName()) ? (String)this.tableAlias.get(tableExpression.getRoot()) : ""));
        return this;
    }

    @Override
    public Searchable where(ColumnExpression columnExpression, ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        super.buildWhere(columnExpression, columnExpressions);
        return this;
    }

    @Override
    public Searchable and(ColumnExpression columnExpression, ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.buildAnd(columnExpression, columnExpressions);
        return this;
    }

    @Override
    public Searchable and(String sql) throws EnhanceFrameworkException {
        this.buildAnd(sql);
        return this;
    }

    @Override
    public Searchable or(ColumnExpression columnExpression, ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.buildOr(columnExpression, columnExpressions);
        return this;
    }

    @Override
    public Searchable count(ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.setFuntionType(FunctionTypeEnum.COUNT, columnExpressions);
        return this;
    }

    @Override
    public Searchable avg(ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.setFuntionType(FunctionTypeEnum.AVG, columnExpressions);
        return this;
    }

    @Override
    public Searchable sum(ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.setFuntionType(FunctionTypeEnum.SUM, columnExpressions);
        return this;
    }

    @Override
    public Searchable min(ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.setFuntionType(FunctionTypeEnum.MIN, columnExpressions);
        return this;
    }

    @Override
    public Searchable max(ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.setFuntionType(FunctionTypeEnum.MAX, columnExpressions);
        return this;
    }

    @Override
    public Searchable join(ColumnExpression onColumn, ColumnExpression joinColumn) throws EnhanceFrameworkException {
        this.sql.JOIN(this.formatterJoinSql(onColumn, joinColumn));
        return this;
    }

    @Override
    public Searchable leftJoin(ColumnExpression onColumn, ColumnExpression joinColumn) {
        this.sql.LEFT_OUTER_JOIN(this.formatterJoinSql(onColumn, joinColumn));
        return this;
    }

    @Override
    public Searchable innerJoin(ColumnExpression onColumn, ColumnExpression joinColumn) {
        this.sql.INNER_JOIN(this.formatterJoinSql(onColumn, joinColumn));
        return this;
    }

    @Override
    public Searchable rightJoin(ColumnExpression onColumn, ColumnExpression joinColumn) {
        this.sql.RIGHT_OUTER_JOIN(this.formatterJoinSql(onColumn, joinColumn));
        return this;
    }

    @Override
    public Searchable orderBy(ColumnExpression columnExpression, SortEnum sortEnum) {
        this.sql.ORDER_BY("\n" + this.getColumnWithTableAlias(columnExpression) + "\n" + sortEnum.toString() + "\n");
        return this;
    }

    @Override
    public Searchable orderBy(String sql, SortEnum sortEnum) throws EnhanceFrameworkException {
        this.sql.ORDER_BY(sql + "\n" + sortEnum.toString() + "\n");
        return this;
    }

    @Override
    public Searchable groupBy(ColumnExpression ... columnExpressions) {
        for (ColumnExpression columnExpression : columnExpressions) {
            this.sql.GROUP_BY(this.getColumnWithTableAlias(columnExpression));
        }
        return this;
    }

    @Override
    public Searchable offset(int offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public Searchable limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public Searchable distinct(boolean distinct) throws EnhanceFrameworkException {
        this.distinct = distinct;
        return this;
    }

    @Override
    public Searchable resultType(Class<?> resultTypeClass) {
        this.resultType = resultTypeClass;
        return this;
    }

    @Override
    public String getSql() throws EnhanceFrameworkException {
        this.getSQLPre();
        String _sql = super.getSql();
        this.params.put("limit", this.limit);
        this.params.put("offset", this.offset);
        if (this.limit > 0) {
            _sql = _sql + "\nlimit\n#{offset},#{limit}";
        }
        return _sql;
    }

    @Override
    public Class<?> getResultType() throws EnhanceFrameworkException {
        return this.resultType;
    }

    @Override
    public Map getParams() throws EnhanceFrameworkException {
        return this.params;
    }

    @Override
    public <T> List<T> fetch() throws EnhanceFrameworkException {
        return this.enhanceDsl.select(this);
    }

    @Override
    public <T> T fetchOne() throws EnhanceFrameworkException {
        return this.enhanceDsl.selectOne(this);
    }

    private void getSQLPre() throws EnhanceFrameworkException {
        this.putSelectColumns();
        this.putFunctionColumns();
        this.putSelectSQLColumns();
    }

    private void putSelectSQLColumns() {
        for (String asName : this.selectSQLColumns.keySet()) {
            String sql = this.selectSQLColumns.get(asName);
            this.sql.SELECT(sql + "\n" + PlaceholderEnum.AS + "\n" + asName);
        }
    }

    private void putSelectColumns() {
        for (ColumnExpression columnExpression : this.selectColumns) {
            boolean isHaveAsName;
            String columnName = this.getColumnWithTableAlias(columnExpression);
            boolean bl = isHaveAsName = !StringUtils.isEmpty((Object)columnExpression.getAsName());
            if (isHaveAsName) {
                columnName = columnName + "\n" + PlaceholderEnum.AS + "\n" + columnExpression.getAsName();
            }
            if (!this.distinct) {
                this.sql.SELECT(columnName);
                continue;
            }
            this.sql.SELECT_DISTINCT(columnName);
        }
    }

    private void putFunctionColumns() {
        for (ColumnExpression columnExpression : this.functionColumns) {
            boolean isHaveAsName;
            String columnName;
            String functionColumnForrmatter = this.checkFunctionColumn(columnExpression, columnName = this.getColumnWithTableAlias(columnExpression), isHaveAsName = !StringUtils.isEmpty((Object)columnExpression.getAsName()));
            if (!StringUtils.isEmpty((Object)functionColumnForrmatter)) {
                columnName = functionColumnForrmatter;
            }
            if (!this.distinct) {
                this.sql.SELECT(columnName);
                continue;
            }
            this.sql.SELECT_DISTINCT(columnName);
        }
    }

    private String checkFunctionColumn(ColumnExpression columnExpression, String columnName, boolean isHaveAsName) {
        String funColumnName = null;
        if (columnExpression.isCount()) {
            funColumnName = "\ncount(" + columnName + ")\n" + (isHaveAsName ? columnExpression.getAsName() : columnExpression.getRoot());
        } else if (columnExpression.isSum()) {
            funColumnName = "\nsum(" + columnName + ")\n" + (isHaveAsName ? columnExpression.getAsName() : columnExpression.getRoot());
        } else if (columnExpression.isAvg()) {
            funColumnName = "\navg(" + columnName + ")\n" + (isHaveAsName ? columnExpression.getAsName() : columnExpression.getRoot());
        } else if (columnExpression.isMax()) {
            funColumnName = "\nmax(" + columnName + ")\n" + (isHaveAsName ? columnExpression.getAsName() : columnExpression.getRoot());
        } else if (columnExpression.isMin()) {
            funColumnName = "\nmin(" + columnName + ")\n" + (isHaveAsName ? columnExpression.getAsName() : columnExpression.getRoot());
        }
        return funColumnName;
    }

    private String formatterJoinSql(ColumnExpression onColumn, ColumnExpression joinColumn) throws EnhanceFrameworkException {
        StringBuffer joinSql = new StringBuffer();
        TableExpression joinTable = joinColumn.getTableExpression();
        String joinTableAsName = joinTable.getAsName();
        boolean joinTableIsHaveAs = !StringUtils.isEmpty((Object)joinTableAsName);
        String joinTableName = joinTable.getRoot();
        TableExpression onTable = onColumn.getTableExpression();
        String onTableName = onTable.getRoot();
        this.checkTableAlias(joinTable);
        this.checkTableAlias(onTable);
        joinSql.append("\n" + joinTable.getRoot() + "\n");
        joinSql.append(joinTableIsHaveAs ? (String)this.tableAlias.get(joinTableName) : "");
        joinSql.append("\non\n");
        joinSql.append((String)this.tableAlias.get(joinTableName));
        joinSql.append("." + joinColumn.getRoot());
        joinSql.append("\n=\n");
        joinSql.append((String)this.tableAlias.get(onTableName));
        joinSql.append("." + onColumn.getRoot() + "\n");
        return joinSql.toString();
    }

    void setFuntionType(FunctionTypeEnum function, ColumnExpression ... columnExpressions) {
        for (ColumnExpression ce : columnExpressions) {
            switch (function) {
                case COUNT: {
                    ce.setCount(true);
                    break;
                }
                case AVG: {
                    ce.setAvg(true);
                    break;
                }
                case SUM: {
                    ce.setSum(true);
                    break;
                }
                case MAX: {
                    ce.setMax(true);
                    break;
                }
                case MIN: {
                    ce.setMin(true);
                }
            }
            this.functionColumns.add(ce);
        }
    }

    boolean checkHaveFunction(ColumnExpression columnExpression) {
        return columnExpression.isCount() || columnExpression.isAvg() || columnExpression.isMax() || columnExpression.isMin() || columnExpression.isSum();
    }

    static enum FunctionTypeEnum {
        COUNT,
        AVG,
        SUM,
        MAX,
        MIN;

    }
}

