/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.dsl.where.sql.support;

import com.gitee.hengboy.mybatis.enhance.dsl.expression.ColumnExpression;
import com.gitee.hengboy.mybatis.enhance.dsl.expression.TableExpression;
import com.gitee.hengboy.mybatis.enhance.dsl.where.sql.ColumnWhereSQL;
import com.gitee.hengboy.mybatis.enhance.dsl.where.sql.entity.ColumnWhereSQLEntity;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public abstract class AbstractColumnWhereSupport
implements ColumnWhereSQL {
    protected ColumnWhereSQLEntity whereSQLEntity = new ColumnWhereSQLEntity();
    protected Map<String, String> tableAlias = new HashMap<String, String>();
    protected int paramIndex;

    protected String getColumnWithTableAlias(ColumnExpression columnExpression) throws EnhanceFrameworkException {
        String columnName = columnExpression.getRoot();
        String tableName = this.tableAlias.get(columnExpression.getTableName());
        if (StringUtils.isEmpty((Object)tableName)) {
            this.checkTableAlias(columnExpression.getTableExpression());
        }
        columnName = this.tableAlias.get(columnExpression.getTableName()) + "." + columnName;
        return columnName;
    }

    protected void checkTableAlias(TableExpression tableExpression) throws EnhanceFrameworkException {
        String tableName = tableExpression.getRoot();
        if (!StringUtils.isEmpty((Object)tableExpression.getAsName())) {
            this.tableAlias.put(tableExpression.getRoot(), tableExpression.getAsName());
        } else {
            this.tableAlias.put(tableName, tableName);
        }
    }

    @Override
    public void setParamIndex(int paramIndex) throws EnhanceFrameworkException {
        this.paramIndex = paramIndex;
    }

    protected String getParamName(ColumnExpression columnExpression, int index) {
        String columnName = this.getColumnWithTableAlias(columnExpression);
        return columnName.replace(".", "_") + "_" + this.paramIndex + "_" + index;
    }

    protected void singleEqValue(ColumnExpression expression, int index, Object value) {
        String placeholer = expression.getPlaceholers().get(index).getValue();
        String columnName = this.getColumnWithTableAlias(expression);
        String paramName = this.getParamName(expression, index);
        this.whereSQLEntity.getParamNames().add(paramName);
        this.whereSQLEntity.getValues().add(value);
        this.whereSQLEntity.getSqls().add(columnName + "\n" + placeholer + (value != null ? "\n#{" + paramName + "}" : ""));
    }

    protected void singleNeValue(ColumnExpression expression, int index, Object value) {
        this.singleEqValue(expression, index, value);
    }

    protected void collectionEqValue(ColumnExpression expression, int index, Object[] values) {
        for (Object value : values) {
            this.singleEqValue(expression, index, value);
        }
    }

    protected void collectionNeValue(ColumnExpression expression, int index, Object[] values) {
        for (Object value : values) {
            this.singleNeValue(expression, index, value);
        }
    }
}

