/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.dsl.where.support;

import com.gitee.hengboy.mybatis.enhance.common.enums.PlaceholderEnum;
import com.gitee.hengboy.mybatis.enhance.dsl.expression.ColumnExpression;
import com.gitee.hengboy.mybatis.enhance.dsl.expression.TableExpression;
import com.gitee.hengboy.mybatis.enhance.dsl.where.Whereable;
import com.gitee.hengboy.mybatis.enhance.dsl.where.filter.WhereFilter;
import com.gitee.hengboy.mybatis.enhance.dsl.where.sql.ColumnWhereSQL;
import com.gitee.hengboy.mybatis.enhance.dsl.where.sql.entity.ColumnWhereSQLEntity;
import com.gitee.hengboy.mybatis.enhance.dsl.where.sql.support.ColumnWhereFactory;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class WhereableSupport
implements Whereable {
    protected Map<String, String> tableAlias = new HashMap<String, String>();
    protected HashMap<String, Object> params = new HashMap();
    protected SQL sql = new SQL();
    protected int paramIndex;

    @Override
    @Deprecated
    public void buildWhere(WhereFilter firstFilter, WhereFilter ... filters) throws EnhanceFrameworkException {
        ArrayList<WhereFilter> filterList = new ArrayList<WhereFilter>();
        filterList.add(firstFilter);
        if (!ObjectUtils.isEmpty((Object[])filters)) {
            filterList.addAll(Arrays.asList(filters));
        }
        for (WhereFilter filter : filterList) {
            String columnName = this.getColumnWithTableAlias(filter.getColumnExpression());
            String paramName = this.getParamName(filter.getColumnExpression(), PlaceholderEnum.AND.getValue().trim());
            this.sql.WHERE(columnName + "\n" + filter.getPlaceholder().getValue() + "\n#{" + paramName + "}");
            this.params.put(paramName, filter.getValue());
        }
    }

    @Override
    public void buildWhere(ColumnExpression columnExpression, ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        ArrayList<ColumnExpression> expressions = new ArrayList<ColumnExpression>();
        expressions.add(columnExpression);
        if (!ObjectUtils.isEmpty((Object[])columnExpressions)) {
            expressions.addAll(Arrays.asList(columnExpressions));
        }
        for (ColumnExpression expression : expressions) {
            ++this.paramIndex;
            for (int i = 0; i < expression.getValues().size(); ++i) {
                ColumnWhereSQL columnWhereSQL = ColumnWhereFactory.newInstance(expression.getPlaceholers().get(i), this.paramIndex);
                ColumnWhereSQLEntity whereSQLEntity = columnWhereSQL.getColumnWhere(expression, i);
                for (int k = 0; k < whereSQLEntity.getSqls().size(); ++k) {
                    this.sql.WHERE(whereSQLEntity.getSqls().get(k));
                }
                for (int j = 0; j < whereSQLEntity.getParamNames().size(); ++j) {
                    this.params.put(whereSQLEntity.getParamNames().get(j), whereSQLEntity.getValues().get(j));
                }
            }
            expression.getValues().clear();
            expression.getPlaceholers().clear();
        }
    }

    @Override
    @Deprecated
    public void buildAnd(WhereFilter whereFilter, WhereFilter ... filters) throws EnhanceFrameworkException {
        this.buildWhere(whereFilter, filters);
    }

    @Override
    public void buildAnd(String sql) throws EnhanceFrameworkException {
        this.sql.WHERE(sql);
    }

    @Override
    public void buildAnd(ColumnExpression columnExpression, ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.buildWhere(columnExpression, columnExpressions);
    }

    @Override
    public void buildOr(ColumnExpression columnExpression, ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.sql.OR();
        this.buildWhere(columnExpression, columnExpressions);
    }

    @Override
    @Deprecated
    public void buildOr(WhereFilter firstFilter, WhereFilter ... filters) throws EnhanceFrameworkException {
        this.sql.OR();
        ArrayList<WhereFilter> filterList = new ArrayList<WhereFilter>();
        filterList.add(firstFilter);
        if (!ObjectUtils.isEmpty((Object[])filters)) {
            filterList.addAll(Arrays.asList(filters));
        }
        for (WhereFilter filter : filterList) {
            String columnName = this.getColumnWithTableAlias(filter.getColumnExpression());
            String paramName = this.getParamName(filter.getColumnExpression(), PlaceholderEnum.OR.getValue().trim());
            this.sql.WHERE(columnName + "\n" + filter.getPlaceholder().getValue() + "\n#{" + paramName + "}");
            this.params.put(paramName, filter.getValue());
        }
    }

    protected String getColumnWithTableAlias(ColumnExpression columnExpression) throws EnhanceFrameworkException {
        String columnName = columnExpression.getRoot();
        String tableName = this.tableAlias.get(columnExpression.getTableName());
        if (StringUtils.isEmpty((Object)tableName)) {
            this.checkTableAlias(columnExpression.getTableExpression());
        }
        columnName = this.tableAlias.get(columnExpression.getTableName()) + "." + columnName;
        return columnName;
    }

    protected void checkTableAlias(TableExpression tableExpression) throws EnhanceFrameworkException {
        String tableName = tableExpression.getRoot();
        if (!StringUtils.isEmpty((Object)tableExpression.getAsName())) {
            this.tableAlias.put(tableExpression.getRoot(), tableExpression.getAsName());
        } else {
            this.tableAlias.put(tableName, tableName);
        }
    }

    protected String getParamName(ColumnExpression columnExpression, String prefix) {
        String columnName = this.getColumnWithTableAlias(columnExpression);
        return columnName.replace(".", "_") + "_" + prefix + "_" + this.paramIndex;
    }

    @Override
    public Map getParams() throws EnhanceFrameworkException {
        return this.params;
    }

    @Override
    public String getSql() throws EnhanceFrameworkException {
        return this.sql.toString();
    }
}

