/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.pageable;

import com.gitee.hengboy.mybatis.pageable.Page;
import com.gitee.hengboy.mybatis.pageable.request.Pageable;
import java.util.List;

public class DefaultPage<T>
implements Page<T> {
    private List<T> data;
    private Pageable pageable;
    private long totalElements;

    public void setData(List<T> data) {
        this.data = data;
    }

    public void setTotalElements(long totalElements) {
        this.totalElements = totalElements;
    }

    @Override
    public List<T> getData() {
        return this.data;
    }

    @Override
    public long getTotalPages() {
        long totalPage = this.getTotalElements() / (long)this.getPageSize();
        return this.getTotalElements() % (long)this.getPageSize() == 0L ? totalPage : totalPage + 1L;
    }

    @Override
    public long getTotalElements() {
        return this.totalElements;
    }

    @Override
    public int getPageIndex() {
        return this.pageable.getPageIndex();
    }

    @Override
    public int getPageSize() {
        return this.pageable.getPageSize();
    }

    @Override
    public long getOffset() {
        return this.pageable.getOffset();
    }

    @Override
    public long getEndRow() {
        return this.pageable.getEndRow();
    }

    @Override
    public boolean hasPrevious() {
        return this.pageable.getPageIndex() > 1;
    }

    @Override
    public boolean isFirst() {
        return this.pageable.getPageIndex() == 1;
    }

    @Override
    public boolean hasNext() {
        return this.getTotalPages() > (long)this.getPageIndex();
    }

    @Override
    public boolean isLast() {
        return this.getTotalPages() == (long)this.getPageIndex();
    }

    DefaultPage(List<T> data, Pageable pageable, long totalElements) {
        this.data = data;
        this.pageable = pageable;
        this.totalElements = totalElements;
    }

    public static <T> DefaultPageBuilder<T> builder() {
        return new DefaultPageBuilder();
    }

    public static class DefaultPageBuilder<T> {
        private List<T> data;
        private Pageable pageable;
        private long totalElements;

        DefaultPageBuilder() {
        }

        public DefaultPageBuilder<T> data(List<T> data) {
            this.data = data;
            return this;
        }

        public DefaultPageBuilder<T> pageable(Pageable pageable) {
            this.pageable = pageable;
            return this;
        }

        public DefaultPageBuilder<T> totalElements(long totalElements) {
            this.totalElements = totalElements;
            return this;
        }

        public DefaultPage<T> build() {
            return new DefaultPage<T>(this.data, this.pageable, this.totalElements);
        }

        public String toString() {
            return "DefaultPage.DefaultPageBuilder(data=" + this.data + ", pageable=" + this.pageable + ", totalElements=" + this.totalElements + ")";
        }
    }
}

