/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.pageable.common;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;

public final class MappedStatementHelper {
    private static final String COUNT_STATEMENT_SUFFIX = "_PAGEABLE_COUNT";
    private static final Hashtable<String, MappedStatement> COUNT_STATEMENT_CACHE = new Hashtable();

    public static MappedStatement initOrGetCountStatement(MappedStatement statement) {
        String statementId = statement.getId() + COUNT_STATEMENT_SUFFIX;
        MappedStatement countStatement = COUNT_STATEMENT_CACHE.get(statementId);
        if (countStatement != null) {
            return countStatement;
        }
        countStatement = MappedStatementHelper.initCountStatement(statement);
        COUNT_STATEMENT_CACHE.put(countStatement.getId(), countStatement);
        return countStatement;
    }

    public static MappedStatement initCountStatement(MappedStatement statement) {
        MappedStatement.Builder builder = new MappedStatement.Builder(statement.getConfiguration(), statement.getId() + COUNT_STATEMENT_SUFFIX, statement.getSqlSource(), statement.getSqlCommandType());
        builder.parameterMap(statement.getParameterMap());
        builder.statementType(statement.getStatementType());
        builder.resource(statement.getResource());
        builder.resultSetType(statement.getResultSetType());
        builder.flushCacheRequired(statement.isFlushCacheRequired());
        builder.useCache(statement.isUseCache());
        final ResultMap resultMap = new ResultMap.Builder(statement.getConfiguration(), statement.getId(), Long.class, new ArrayList()).build();
        builder.resultMaps((List)new ArrayList(){
            {
                this.add(resultMap);
            }
        });
        return builder.build();
    }
}

