/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.pageable.dialect;

import com.gitee.hengboy.mybatis.pageable.Page;
import com.gitee.hengboy.mybatis.pageable.PageParameterSortMapping;
import com.gitee.hengboy.mybatis.pageable.dialect.Dialect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

public abstract class AbstractDialect
implements Dialect {
    private static final String COUNT_SQL_PREFIX = "SELECT COUNT(0) FROM ( ";
    private static final String COUNT_SQL_SUFFIX = " ) TEMP_COUNT";
    protected static final String PRE_PLACEHOLDER = "?";
    private static final String PAGE_KEYWORD_LIMIT = " LIMIT ";
    private static final String PAGE_KEYWORD_OFFSET = " OFFSET ";
    protected static final String PAGE_KEYWORD_SELECT = "SELECT";
    protected static final String PARAM_PAGE_OFFSET = "pageable_page_offset_";
    protected static final String PARAM_PAGE_END = "pageable_page_end_";
    protected static final String PARAM_PAGE_SIZE = "pageable_page_size_";

    @Override
    public String getCountSql(BoundSql boundSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(COUNT_SQL_PREFIX);
        sql.append(boundSql.getSql());
        sql.append(COUNT_SQL_SUFFIX);
        return sql.toString();
    }

    @Override
    public Object getPageParameter(Object parameter, Page page) {
        HashMap<String, Object> pageParameter = new HashMap<String, Object>();
        if (parameter instanceof Map) {
            pageParameter.putAll((Map)parameter);
        } else {
            MetaObject metaObject = SystemMetaObject.forObject((Object)parameter);
            for (String name : metaObject.getGetterNames()) {
                pageParameter.put(name, metaObject.getValue(name));
            }
        }
        pageParameter.put(PARAM_PAGE_SIZE, page.getPageSize());
        pageParameter.put(PARAM_PAGE_OFFSET, page.getOffset());
        pageParameter.put(PARAM_PAGE_END, page.getEndRow());
        return pageParameter;
    }

    @Override
    public void addPageMapping(BoundSql pageBoundSql, MappedStatement statement, Page page) {
        if (pageBoundSql.getParameterMappings() != null) {
            ArrayList<ParameterMapping> newParameterMappings = new ArrayList<ParameterMapping>();
            if (pageBoundSql != null && pageBoundSql.getParameterMappings() != null) {
                newParameterMappings.addAll(pageBoundSql.getParameterMappings());
            }
            List<PageParameterSortMapping> sortParameterMappings = this.getSortParameterMapping();
            for (PageParameterSortMapping mapping : sortParameterMappings) {
                newParameterMappings.add(new ParameterMapping.Builder(statement.getConfiguration(), mapping.getParameterName(), mapping.getTypeClass()).build());
            }
            MetaObject metaObject = SystemMetaObject.forObject((Object)pageBoundSql);
            metaObject.setValue("parameterMappings", newParameterMappings);
        }
    }

    @Override
    public String getPageSql(BoundSql boundSql, Page page) {
        StringBuilder sql = new StringBuilder();
        sql.append(boundSql.getSql());
        sql.append(PAGE_KEYWORD_LIMIT);
        sql.append(PRE_PLACEHOLDER);
        sql.append(PAGE_KEYWORD_OFFSET);
        sql.append(PRE_PLACEHOLDER);
        return sql.toString();
    }
}

