/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.pageable.dialect;

import com.gitee.hengboy.mybatis.pageable.common.enums.DialectEnum;
import com.gitee.hengboy.mybatis.pageable.common.exception.ErrorMsgEnum;
import com.gitee.hengboy.mybatis.pageable.common.exception.PageableException;
import com.gitee.hengboy.mybatis.pageable.dialect.Dialect;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.MappedStatement;

public class DialectDynamicFactory {
    private static final Map<String, DialectEnum> URL_DIALECT_MAPPING = new HashMap<String, DialectEnum>();

    private DialectDynamicFactory() {
    }

    public static Dialect newInstance(MappedStatement statement, String dialect) {
        try {
            if (dialect == null) {
                return DialectDynamicFactory.newAutoInstance(statement);
            }
            return (Dialect)Class.forName(dialect).newInstance();
        }
        catch (Exception e) {
            throw new PageableException(ErrorMsgEnum.DIALECT_NOT_FOUND, new String[0]);
        }
    }

    public static Dialect newAutoInstance(MappedStatement statement) {
        try {
            DataSource dataSource = statement.getConfiguration().getEnvironment().getDataSource();
            String jdbcUrl = dataSource.getConnection().getMetaData().getURL();
            DialectEnum dialectEnum = DialectDynamicFactory.loopGetDialect(jdbcUrl);
            return dialectEnum.getValue().newInstance();
        }
        catch (Exception e) {
            throw new PageableException(ErrorMsgEnum.DIALECT_NOT_FOUND, new String[0]);
        }
    }

    static DialectEnum loopGetDialect(String jdbcUrl) {
        for (String urlPrefix : URL_DIALECT_MAPPING.keySet()) {
            if (jdbcUrl.indexOf(urlPrefix) == -1) continue;
            return URL_DIALECT_MAPPING.get(urlPrefix);
        }
        return null;
    }

    static {
        URL_DIALECT_MAPPING.put("jdbc:mysql", DialectEnum.MYSQL);
        URL_DIALECT_MAPPING.put("jdbc:sqlite", DialectEnum.MYSQL);
        URL_DIALECT_MAPPING.put("jdbc:mariadb", DialectEnum.MYSQL);
        URL_DIALECT_MAPPING.put("jdbc:oracle", DialectEnum.ORACLE);
        URL_DIALECT_MAPPING.put("jdbc:dm", DialectEnum.ORACLE);
        URL_DIALECT_MAPPING.put("jdbc:db2", DialectEnum.DB2);
        URL_DIALECT_MAPPING.put("jdbc:postgresql", DialectEnum.POSTGRES);
        URL_DIALECT_MAPPING.put("jdbc:sqlserver", DialectEnum.SQLSERVER);
        URL_DIALECT_MAPPING.put("jdbc:derby", DialectEnum.SQLSERVER);
        URL_DIALECT_MAPPING.put("jdbc:hsqldb:hsql", DialectEnum.HSQL);
        URL_DIALECT_MAPPING.put("jdbc:h2", DialectEnum.HSQL);
        URL_DIALECT_MAPPING.put("jdbc:informix-sqli", DialectEnum.INfORMIX);
        URL_DIALECT_MAPPING.put("jdbc:informix", DialectEnum.INfORMIX);
    }
}

