/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.pageable.dialect.support;

import com.gitee.hengboy.mybatis.pageable.Page;
import com.gitee.hengboy.mybatis.pageable.PageParameterSortMapping;
import com.gitee.hengboy.mybatis.pageable.dialect.AbstractDialect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;

public class Db2Dialect
extends AbstractDialect {
    @Override
    public List<PageParameterSortMapping> getSortParameterMapping() {
        return new ArrayList(){
            {
                this.add(PageParameterSortMapping.builder().parameterName("pageable_page_offset_").typeClass(Long.class).build());
                this.add(PageParameterSortMapping.builder().parameterName("pageable_page_size_").typeClass(Integer.class).build());
            }
        };
    }

    @Override
    public Object getPageParameter(Object parameter, Page page) {
        Map pageParameter = (Map)super.getPageParameter(parameter, page);
        pageParameter.put("pageable_page_offset_", page.getOffset() + 1L);
        return pageParameter;
    }

    @Override
    public String getPageSql(BoundSql boundSql, Page page) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM (SELECT PAGEABLE_.*,ROWNUMBER() OVER() AS ROW_ID FROM ( ");
        sql.append(boundSql.getSql());
        sql.append(" ) AS PAGEABLE_) PAGEABLE_ WHERE ROW_ID BETWEEN ? AND ?");
        return sql.toString();
    }
}

