/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.pageable.interceptor;

import com.gitee.hengboy.mybatis.pageable.DefaultPage;
import com.gitee.hengboy.mybatis.pageable.Page;
import com.gitee.hengboy.mybatis.pageable.common.ExecutorHelper;
import com.gitee.hengboy.mybatis.pageable.common.MappedStatementHelper;
import com.gitee.hengboy.mybatis.pageable.common.PageableRequestHelper;
import com.gitee.hengboy.mybatis.pageable.dialect.Dialect;
import com.gitee.hengboy.mybatis.pageable.dialect.DialectDynamicFactory;
import com.gitee.hengboy.mybatis.pageable.executor.ExecutorQueryRequest;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class MyBatisExecutePageableInterceptor
implements Interceptor {
    private String dialect;

    public Object intercept(Invocation invocation) throws Throwable {
        if (PageableRequestHelper.getPageLocal() == null) {
            return invocation.proceed();
        }
        Object[] args = invocation.getArgs();
        MappedStatement statement = (MappedStatement)args[0];
        Executor executor = (Executor)invocation.getTarget();
        DefaultPage pageable = (DefaultPage)PageableRequestHelper.getPageLocal();
        Dialect dialect = DialectDynamicFactory.newInstance(statement, this.dialect);
        ExecutorQueryRequest queryRequest = this.buildExecutorQueryRequest(args);
        pageable.setData(this.executeQuery(executor, queryRequest, pageable, dialect));
        pageable.setTotalElements(this.executeCount(executor, queryRequest, dialect));
        return pageable.getData();
    }

    private ExecutorQueryRequest buildExecutorQueryRequest(Object[] args) {
        MappedStatement statement = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = RowBounds.DEFAULT;
        ResultHandler resultHandler = (ResultHandler)args[3];
        BoundSql boundSql = statement.getBoundSql(parameter);
        return ExecutorQueryRequest.builder().statement(statement).parameter(parameter).rowBounds(rowBounds).resultHandler(resultHandler).boundSql(boundSql).build();
    }

    private Long executeCount(Executor executor, ExecutorQueryRequest request, Dialect dialect) throws SQLException {
        MappedStatement statement = MappedStatementHelper.initOrGetCountStatement(request.getStatement());
        BoundSql boundSql = request.getBoundSql();
        String countSql = dialect.getCountSql(boundSql);
        Object parameter = request.getParameter();
        BoundSql countBoundSql = new BoundSql(statement.getConfiguration(), countSql, boundSql.getParameterMappings(), parameter);
        CacheKey countKey = executor.createCacheKey(statement, parameter, RowBounds.DEFAULT, countBoundSql);
        ExecutorQueryRequest countQueryRequest = ExecutorQueryRequest.builder().boundSql(countBoundSql).statement(statement).rowBounds(request.getRowBounds()).cacheKey(countKey).parameter(parameter).resultHandler(request.getResultHandler()).build();
        List countResultList = ExecutorHelper.query(executor, countQueryRequest);
        return ((Number)countResultList.get(0)).longValue();
    }

    private List executeQuery(Executor executor, ExecutorQueryRequest request, Page pageable, Dialect dialect) throws SQLException {
        MappedStatement statement = request.getStatement();
        BoundSql boundSql = request.getBoundSql();
        String dataSql = dialect.getPageSql(request.getBoundSql(), pageable);
        Object pageParameter = dialect.getPageParameter(request.getParameter(), pageable);
        BoundSql pageBoundSql = new BoundSql(statement.getConfiguration(), dataSql, boundSql.getParameterMappings(), pageParameter);
        dialect.addPageMapping(pageBoundSql, statement, pageable);
        CacheKey dataKey = executor.createCacheKey(statement, pageParameter, request.getRowBounds(), pageBoundSql);
        ExecutorQueryRequest pageQueryRequest = ExecutorQueryRequest.builder().boundSql(pageBoundSql).statement(statement).rowBounds(request.getRowBounds()).cacheKey(dataKey).parameter(pageParameter).resultHandler(request.getResultHandler()).build();
        return ExecutorHelper.query(executor, pageQueryRequest);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.dialect = properties.getProperty("dialect");
    }
}

