/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.pageable.request;

import com.gitee.hengboy.mybatis.pageable.DefaultPage;
import com.gitee.hengboy.mybatis.pageable.common.PageableRequestHelper;
import com.gitee.hengboy.mybatis.pageable.common.exception.ErrorMsgEnum;
import com.gitee.hengboy.mybatis.pageable.common.exception.PageableException;
import com.gitee.hengboy.mybatis.pageable.request.Pageable;

public abstract class AbstractPageRequest
implements Pageable {
    protected int pageIndex;
    protected int pageSize;

    public AbstractPageRequest(int pageIndex, int pageSize) {
        if (pageIndex < 1) {
            throw new PageableException(ErrorMsgEnum.PAGE_INDEX_FAILED, new String[0]);
        }
        if (pageSize < 1) {
            throw new PageableException(ErrorMsgEnum.PAGE_SIZE_FAILED, new String[0]);
        }
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.setPageThreadLocal();
    }

    private void setPageThreadLocal() {
        DefaultPage page = DefaultPage.builder().pageable(this).build();
        PageableRequestHelper.setPageLocal(page);
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public long getOffset() {
        return (long)(this.pageIndex - 1) * (long)this.pageSize;
    }

    @Override
    public long getEndRow() {
        return this.pageIndex * this.pageSize;
    }
}

