/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.pageable.request;

import com.gitee.hengboy.mybatis.pageable.LogicFunction;
import com.gitee.hengboy.mybatis.pageable.Page;
import com.gitee.hengboy.mybatis.pageable.common.PageableRequestHelper;
import com.gitee.hengboy.mybatis.pageable.request.AbstractPageRequest;
import com.gitee.hengboy.mybatis.pageable.request.Pageable;

public class PageableRequest
extends AbstractPageRequest {
    private PageableRequest(int pageIndex, int pageSize) {
        super(pageIndex, pageSize);
    }

    public static Pageable of(int pageIndex, int pageSize) {
        return new PageableRequest(pageIndex, pageSize);
    }

    @Override
    public <T> Page<T> request(LogicFunction logicFunction) {
        logicFunction.invoke();
        Page<?> page = PageableRequestHelper.getPageLocal();
        PageableRequestHelper.removePageLocal();
        return page;
    }

    @Override
    public Pageable next() {
        return PageableRequest.of(this.pageIndex + 1, this.pageSize);
    }

    @Override
    public Pageable previous() {
        return this.pageIndex == 1 ? this : PageableRequest.of(this.pageIndex - 1, this.pageSize);
    }

    @Override
    public Pageable first() {
        return PageableRequest.of(1, this.pageSize);
    }
}

