package net.facelib.authkernel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import com.facebook.swift.codec.ThriftEnumValue;

/**
 * 授权错误类型定义
 * @author guyadong
 *
 */
public enum AuthKernelErrorType{
    /** thrift 传输层异常(未知类型) */THRIFT_TRANS_UNKNOWN(-93),
    /** thrift 传输层异常(打开失败) */THRIFT_TRANS_NOT_OPEN(-92),
    /** thrift 传输层异常(超时) */THRIFT_TRANS_TIMED_OUT(-91),
    /** thrift 传输层异常(文件结尾) */THRIFT_TRANS_END_OF_FILE(-90),
    /** thrift 传输层异常(传输中断) */THRIFT_TRANS_INTERRUPTED(-89),
    /** thrift 传输层异常(参数错误) */THRIFT_TRANS_BAD_ARGS(-88),
    /** thrift 传输层异常(数据损坏) */THRIFT_TRANS_CORRUPTED_DATA(-87),
    /** thrift 传输层异常(内部错误) */THRIFT_TRANS_INTERNAL_ERROR(-86),
    /** thrift 协议层异常(未知类型) */THRIFT_PROT_UNKNOWN(-85),
    /** thrift 协议层异常(无效数据) */THRIFT_PROT_INVALID_DATA(-84),
    /** thrift 协议层异常(负长度) */THRIFT_PROT_NEGATIVE_SIZE(-83),
    /** thrift 协议层异常(长度限制) */THRIFT_PROT_SIZE_LIMIT(-82),
    /** thrift 协议层异常(版本错误) */THRIFT_PROT_BAD_VERSION(-81),
    /** thrift 协议层异常(未实现) */THRIFT_PROT_NOT_IMPLEMENTED(-80),
    /** thrift 协议层异常(深度限制) */THRIFT_PROT_DEPTH_LIMIT(-79),
    /** 服务主机连接失败 */HOST_CONNECT_ERROR(-78),
    /** 无效设备物理地址(CPUID的MD5校验码) */INVALID_CPUIDMD5(-77),
    /** 无效设备物理地址(UUID的MD5校验码,android 11平台使用) */INVALID_UUIDMD5(-76),
    /** 内部服务错误 */INTERNAL_SERVICE_ERROR(-75),
    /** 设备没有指定产品的授权 */DEVICE_NO_PERMIT(-74),
    /** 拒绝黑名单设备  */ REJECT_BLACKLIST(-73),
    /** 拒绝多地址访问  */ REJECT_MULTI_ADDR(-72),
    /** 拒绝高频访问  */ REJECT_HIGH_FREQ(-71),
    /** 数据缓冲区长度不足  */ INSUFFICIENT_BUFFER_SIZE(-70),
    /** DSN:获取序列号失败  */ DSN_FAULT(-69),
    /** PROXY:代理服务地址被拒绝  */ PROXY_REJECT_ADDRESS(-68),
    /** PROXY:无效公司名称  */ PROXY_INVALID_COMPANYSYMBOL(-67),
    /** 附件产品所属的产品的没有授权  */ NOT_FOUND_AUTHORIZED_PARENT_PRODUCT(-66),
    /** 附件产品定义的所属的产品ID无效  */ INVALID_PARENT_ID(-65),
    /** 指定的产品ID不是附件产品  */ NOT_COMPONENT_PRODUCT_ID(-64),
    /** 无效的LDCOUNT文件数据  */ INVALID_LDCOUNT_FILE(-63),
    /** 服务端返回的令牌数据长度为0  */ EMPTY_RESP_TOKEN(-62),
    /** 服务端返回的授权数据长度为0  */ EMPTY_RESP_LICENSE(-61),
    /** LDCOUNT文件数据长度为0  */ EMPTY_LDCOUNT_FILE(-60),
    /** 令牌文件数据长度为0  */ EMPTY_TOKEN_FILE(-59),
    /** 授权文件数据长度为0  */ EMPTY_LICENSE_FILE(-58),
    /** JSON解析错误 */ JSON_ERROR(-57),
    /** 应用上下文运行时异常 */ APPCONTEXT_RUNTIME_ERROR(-56),
    /** JMX应用上下文不可用(应用服务未上线) */ REMOTE_APPCONTEXT_UNAVAILABLE(-55),
    /** JMX应用上下文连接异常(应用服务下线) */ REMOTE_APPCONTEXT_DISCONNECT(-54),
    /** 数据库异常,指定的设备ID对于同一个产品ID找到多条授权记录 */MULTI_MATCHED_LICENSE(-53),
    /** 授权文件数据长度不正确 */LICENSE_FILE_SIZE_MISMATCH(-52),
    /** 获取设备唯一ID失败 */FAIL_TO_GET_DEVICE_SERIAL(-51),
    /** 无效的临时文件夹 */INVALID_TMP_FOLDER(-50),
    /** 文件不存在 */FILE_NO_FOUND(-49),
    /** 文件读写错误 */FILE_IO_ERROR(-48),
    /** AKCORE 未初始化 */AKCORE_UNINITIALIZED(-47),
    /** thrift 运行异常(未知类型) */THRIFT_UNKNOWN(-46),
    /** thrift 运行异常(未知方法) */THRIFT_UNKNOWN_METHOD(-45),
    /** thrift 运行异常(无效消息类型) */THRIFT_INVALID_MESSAGE_TYPE(-44),
    /** thrift 运行异常(错误的方法名) */THRIFT_WRONG_METHOD_NAME(-43),
    /** thrift 运行异常(无效的序列号) */THRIFT_BAD_SEQUENCE_ID(-42),
    /** thrift 运行异常(消息为空) */THRIFT_MISSING_RESULT(-41),
    /** thrift 运行异常(内部错误) */THRIFT_INTERNAL_ERROR(-40),
    /** thrift 运行异常(协议错误) */THRIFT_PROTOCOL_ERROR(-39),
    /** thrift 运行异常(无效传输) */THRIFT_INVALID_TRANSFORM(-38),
    /** thrift 运行异常(无效协议) */THRIFT_INVALID_PROTOCOL(-37),
    /** thrift 运行异常(不支持的CLIENT类型) */THRIFT_UNSUPPORTED_CLIENT_TYPE(-36),
    /** 运行时异常 */RUNTIME_ERROR(-35),
    /** 数据库操作异常 */DAO_ERROR(-34),
    /** 输入参数为NULL */NULL_ARGUMENT(-33),
    /** 无效的输入参数 */INVALID_ARGUMENT(-32),
    /** 空闲序列号数量不能满足指定的数量要求 */INSUFFICIENT_FREE_SN(-31),
    /** 拒绝写入指定的字段 */REJECT_WRITE_FIELD(-30),
    /** 授权状态异常 */LICENSE_STATUS_ERROR(-29),
    /** 序列号下载授权数据次数的计数不匹配 */LD_COUNT_MISMATCH(-28),
    /** 序列号对产品ID授权禁用 */PERMIT_DISABLE(-27),
    /** 序列号对产品ID授权过期 */PERMIT_EXPIRY(-26),
    /** 序列号对产品ID没有授权 */PRODUCT_ID_REJECT_SN(-25),
    /** 没有可用的序列号 */NO_AVAILABLE_SN(-24),
    /** 拒绝访问 */ACCESS_DENIED(-23),
    /** 拒绝令牌申请 */REJECT_APPLY(-22),
    /** 产品拒绝授权类型  */REJECT_AUTH_OP_TYPE(-21),
    /** 设备物理地址拒绝授权  */REJECT_DEVICE_ADDRESS(-20),
    /** 无效设备地址类型  */INVALID_ADDRESS_TYPE(-19),
    /** 无效设备状态  */INVALID_DEVICE_STATUS(-18),
    /** 无效授权状态  */INVALID_PERMIT_STATUS(-17),
    /** 未激活用户组状态  */INACTIVE_USER_GROUP_STATUS(-16),
    /** 无效用户组ID */INVALID_USER_GROUP_ID(-15),
    /** 无效设备物理地址 */INVALID_DEVICE_ADDRESS(-14),
    /** 无效设备ID */INVALID_DEVICE_ID(-13),
    /** 无效设备记录 */INVALID_DEVICE_BEAN(-12),
    /** 无效的设备令牌 */INVALID_TOKEN(-11),
    /** 序列号被占用 */OCCUPIED_SN(-10),
    /** 无效产品签名 */INVALID_PRODUCT_SIGN(-9),
    /** 无效产品ID */INVALID_PRODUCT_ID(-8),
    /** 未分配序列号 */UNOWNED_SN(-7),
    /** 无效序列号 */INVALID_SN(-6),
    /** 无效FLASH ID */INVALID_FLASHID(-5),
    /** 无效IMEI(国际移动设备识别码) */INVALID_IMEI(-4),
    /** 无效MAC地址 */INVALID_MAC(-3),
    /** 其他未分类异常 */UNCLASSIFIED(-2),
    /** 无异常 */OK(0);
    /**
     * 枚举值
     */
    private final int value;
    private AuthKernelErrorType(Integer value) {
        this.value = value;
    }
    @ThriftEnumValue
    public int getValue(){
        return value;
    }
    /**
     * 枚举值 - 枚举对象映射
     */
    private static final Map<Integer, AuthKernelErrorType> valueMap = makeValueMap();
            
    private static Map<Integer, AuthKernelErrorType> makeValueMap(){
        Map<Integer, AuthKernelErrorType> vm = new HashMap<>();
        for(AuthKernelErrorType value:values()){
            vm.put(value.getValue(), value);
        }
        return Collections.unmodifiableMap(vm);
    }
    /**
     * 根据value值返回对应的枚举类型,如果找不到value对应的枚举对象则抛出异常
     * @param value
     * @return 枚举对象
     * @throws IllegalArgumentException 找不到value对应的枚举对象
     */
    public static final AuthKernelErrorType fromValue(int value) throws IllegalArgumentException{
        AuthKernelErrorType e = valueMap.get(value);
        if(e != null){
            return e;
        }
        throw new IllegalArgumentException(String.format("INVALID VALUE %d for AuthKernelErrorType", value));
    }
}