package net.facelib.authkernel;

import java.util.Iterator;
import java.util.ServiceLoader;

/**
 * 安全异常
 * @author guyadong
 *
 */
public class ServiceSecurityException extends Exception {
	public static interface FieldJsonTransformer<T> {
		public String jsonOfDeclaredFields(T input);
	}
	/**
	 * SPI(Service Provider Interface)机制加载 {@link FieldJsonTransformer}实例,没有找到返回{@code null}
	 */
	@SuppressWarnings("rawtypes")
	private static FieldJsonTransformer spiTransformer() {		
		ServiceLoader<FieldJsonTransformer> providers = ServiceLoader.load(FieldJsonTransformer.class);
		Iterator<FieldJsonTransformer> itor = providers.iterator();
		if(!itor.hasNext()){
			return null;
		}
		return itor.next();
	}
	private static final long serialVersionUID = 5298414024971333060L;
	@SuppressWarnings("unchecked")
	private static FieldJsonTransformer<ServiceSecurityException> transformer = spiTransformer();
	private AuthKernelErrorType type = AuthKernelErrorType.UNCLASSIFIED;
	public ServiceSecurityException() {
		this((String)null, (Throwable)null);
	}

	public ServiceSecurityException(String message) {
		this(message,(Throwable)null);
	}

	public ServiceSecurityException(String message, Throwable cause) {
		super(message, cause);
	}

	public ServiceSecurityException(Throwable cause) {
		this(null,cause);
	}
	public ServiceSecurityException(String message,AuthKernelErrorType type) {
		this(message);
		if(null == type){
			throw new NullPointerException("type is null");
		}
		this.type = type;
	}
	public ServiceSecurityException(AuthKernelErrorType type) {
		this(null,type);
	}
    /** return exception type */
    public AuthKernelErrorType getType() {
        return type;
    }
    public ServiceSecurityException setType(AuthKernelErrorType type) {
    	if(null != type){
    		this.type = type;
    	}
        return this;
    }
	/**
     * 如果父类方法返回空,则将错误类型{@link #type}名字返回
	 * @see java.lang.Throwable#getMessage()
	 */
	@Override
	public String getMessage() {
		String msg = super.getMessage();
		return msg == null ? type.name() : msg;
	}

	/** return a JSON string of declared fields  */
	@Override
	public String toString() {
		if(null == transformer){
			StringBuilder builder = new StringBuilder();
			builder.append("ServiceSecurityException [type=");
			builder.append(type);
			builder.append(", message()=");
			builder.append(getMessage());
			builder.append("]");
			return builder.toString();
		}
		return transformer.jsonOfDeclaredFields(this);
	} 
	
	static FieldJsonTransformer<ServiceSecurityException> getTransformer() {
		return transformer;
	}

	static void setTransformer(FieldJsonTransformer<ServiceSecurityException> transformer) {
		ServiceSecurityException.transformer = transformer;
	}
}
