/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.cassdk;

import java.util.Iterator;
import java.util.ServiceLoader;
import net.gdface.cassdk.CasAndroidConfigProvider;
import net.gdface.cassdk.DefaultCasAndroidConfig;
import net.gdface.cassdk.SdkInitException;
import net.gdface.cassdk.SdkRuntimeException;
import net.gdface.cassdk.SdkStatus;
import net.gdface.license.LicenseManager;
import net.gdface.license.LicenseUtils;
import net.gdface.utils.Judge;
import net.gdface.utils.SampleLog;

public class CasAndroidArmBridge {
    public static final CasAndroidConfigProvider CONFIG = CasAndroidArmBridge.getConfigProvider();
    public static final LicenseManager LICENSE_MANAGER = LicenseUtils.getLicenseManager();
    final long[] detectHandle = new long[1];
    final long[] featureHandle = new long[1];
    private SdkStatus status = SdkStatus.SDK_UNINITIALIZED;

    CasAndroidArmBridge() {
    }

    private static CasAndroidConfigProvider getConfigProvider() {
        ServiceLoader<CasAndroidConfigProvider> providers = ServiceLoader.load(CasAndroidConfigProvider.class);
        Iterator<CasAndroidConfigProvider> itor = providers.iterator();
        if (!itor.hasNext()) {
            return new DefaultCasAndroidConfig();
        }
        return itor.next();
    }

    SdkStatus getStatus() {
        return this.status;
    }

    private static String zeroEnd(String input) {
        if (input == null) {
            return null;
        }
        if (input.endsWith("\u0000")) {
            return input;
        }
        return input + "\u0000";
    }

    static SdkStatus fdInit(String licenseKey, String licenseCode, CasAndroidArmBridge instance) {
        if (SdkStatus.SDK_INIT_OK == instance.status) {
            return instance.status;
        }
        licenseCode = CasAndroidArmBridge.zeroEnd(licenseCode);
        String szFilePath = "\u0000";
        String szCompanyNames = CasAndroidArmBridge.zeroEnd(licenseKey);
        int fdFlag = CasAndroidArmBridge.FDInit(licenseCode.getBytes(), szCompanyNames.getBytes(), szFilePath.getBytes(), CONFIG.getProcessMinl(), CONFIG.getProcessMaxl(), CONFIG.getDetectThreshold(), instance.detectHandle);
        return SdkStatus.jniCode(fdFlag);
    }

    private static SdkStatus ffInit(String licenseKey, String licenseCode, CasAndroidArmBridge instance) {
        if (SdkStatus.SDK_INIT_OK == instance.status) {
            return instance.status;
        }
        licenseCode = CasAndroidArmBridge.zeroEnd(licenseCode);
        String szFilePath = "\u0000";
        String szCompanyNames = CasAndroidArmBridge.zeroEnd(licenseKey);
        int ffFlag = CasAndroidArmBridge.FFInit(licenseCode.getBytes(), szCompanyNames.getBytes(), szFilePath.getBytes(), instance.featureHandle);
        return SdkStatus.jniCode(ffFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sdkInit(String licenseKey, String licenseCode) throws SdkInitException {
        if (SdkStatus.SDK_INIT_OK == this.status) {
            return;
        }
        SdkStatus fdStatus = SdkStatus.SDK_UNINITIALIZED;
        SdkStatus ffStatus = SdkStatus.SDK_UNINITIALIZED;
        try {
            fdStatus = CasAndroidArmBridge.fdInit(licenseKey, licenseCode, this);
            if (fdStatus != SdkStatus.SDK_INIT_OK) {
                this.status = fdStatus;
                SampleLog.log((String)"detect module: {}", (Object[])new Object[]{this.status.msg});
                throw new SdkInitException(this.status);
            }
            ffStatus = CasAndroidArmBridge.ffInit(licenseKey, licenseCode, this);
            if (ffStatus != SdkStatus.SDK_INIT_OK) {
                this.status = ffStatus;
                SampleLog.log((String)"feature module: {}", (Object[])new Object[]{this.status.msg});
                throw new SdkInitException(this.status);
            }
            this.status = SdkStatus.SDK_INIT_OK;
        }
        finally {
            if (this.status != SdkStatus.SDK_INIT_OK) {
                if (fdStatus != SdkStatus.SDK_INIT_OK) {
                    CasAndroidArmBridge.FDDestroy(this.detectHandle[0]);
                }
                if (ffStatus != SdkStatus.SDK_INIT_OK) {
                    CasAndroidArmBridge.FFDestroy(this.featureHandle[0]);
                }
            }
        }
    }

    CasAndroidArmBridge init() throws SdkInitException {
        String licenseKey = LICENSE_MANAGER.getLicenseKey();
        String licenseCode = LICENSE_MANAGER.getLicenseCode();
        if (Judge.isEmpty((String)licenseKey)) {
            throw new SdkInitException("EMPTY licenseKey,must call setLicenseKey() firstly");
        }
        if (Judge.isEmpty((String)licenseCode)) {
            throw new SdkInitException("EMPTY licenseCode,must call setLicenseCode() firstly");
        }
        this.sdkInit(licenseKey, licenseCode);
        return this;
    }

    void destroy() {
        if (SdkStatus.SDK_INIT_OK == this.status) {
            this.status = SdkStatus.SDK_UNINITIALIZED;
            CasAndroidArmBridge.FDDestroy(this.detectHandle[0]);
            CasAndroidArmBridge.FFDestroy(this.featureHandle[0]);
        }
    }

    public int detect(byte[] BGR, int width, int height, double[] rect) {
        int ret = CasAndroidArmBridge.FDDetect(this.detectHandle[0], BGR, width, height, rect);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode(ret));
        }
        return ret;
    }

    public double[] feaExtract(byte[] BGR, int width, int height, double[] rect) {
        double[] buffer = new double[512];
        int ret = CasAndroidArmBridge.FFFeaExtract(this.featureHandle[0], BGR, width, height, buffer, rect);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode(ret));
        }
        return buffer;
    }

    public byte[] feaExtractByte(byte[] BGR, int width, int height, double[] rect) {
        byte[] buffer = new byte[4096];
        int ret = CasAndroidArmBridge.FFFeaExtractByte(this.featureHandle[0], BGR, width, height, buffer, rect);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode(ret));
        }
        return buffer;
    }

    static native int FSGetDevicesSerial(byte[] var0, byte[] var1);

    private static native int FDInit(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, double var5, long[] var7);

    static native void FDDestroy(long var0);

    private static native int FDDetect(long var0, byte[] var2, int var3, int var4, double[] var5);

    public static native String FDgetVersion();

    private static native int FFInit(byte[] var0, byte[] var1, byte[] var2, long[] var3);

    private static native void FFDestroy(long var0);

    private static native int FFFeaExtract(long var0, byte[] var2, int var3, int var4, double[] var5, double[] var6);

    public static native double FFSimilarity(double[] var0, double[] var1);

    private static native int FFFeaExtractByte(long var0, byte[] var2, int var3, int var4, byte[] var5, double[] var6);

    public static native double FFSimilarityByte(byte[] var0, byte[] var1);

    public static native String FFgetVersion();

    static {
        try {
            System.loadLibrary("FS_AndroidFaceSDK");
        }
        catch (Exception e) {
            SampleLog.log((String)e.getMessage(), (Object[])new Object[0]);
            throw new ExceptionInInitializerError(e);
        }
        LICENSE_MANAGER.installLicenseIfSPIAvailable();
    }
}

