/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.cassdk;

import android.graphics.Bitmap;
import java.util.List;
import net.gdface.cassdk.BridgeInstanceFactory;
import net.gdface.cassdk.CasAndroidArmBridge;
import net.gdface.cassdk.FseAndroidBridge;
import net.gdface.cassdk.NativeFaceInfo;
import net.gdface.cassdk.SdkInitException;
import net.gdface.cassdk.SdkRuntimeException;
import net.gdface.image.BaseLazyImage;
import net.gdface.image.ImageErrorException;
import net.gdface.image.LazyImage;
import net.gdface.license.LicenseManager;
import net.gdface.sdk.BaseFaceApiLocal;
import net.gdface.sdk.CodeInfo;
import net.gdface.sdk.FaceApi;
import net.gdface.sdk.FaceApiGenericDecorator;
import net.gdface.sdk.NotFaceDetectedException;
import net.gdface.sdk.fse.FeatureSe;
import net.gdface.utils.ShareLock;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class FaceApiCasAndroid
extends BaseFaceApiLocal {
    private static final FaceApiCasAndroid INSTANCE = new FaceApiCasAndroid();
    private static final FaceApiGenericDecorator GENERIC_INSTANCE = new FaceApiGenericDecorator((FaceApi)INSTANCE);
    private static final ThreadLocal<double[]> faceBuffer = new ThreadLocal<double[]>(){

        @Override
        protected double[] initialValue() {
            return new double[1952];
        }
    };
    private static final GenericObjectPool<CasAndroidArmBridge> pool;

    protected FaceApiCasAndroid() {
    }

    public static FaceApiCasAndroid getInstance() {
        return INSTANCE;
    }

    public static FaceApiGenericDecorator getGenericInstance() {
        return GENERIC_INSTANCE;
    }

    public static LicenseManager licenseManager() {
        return CasAndroidArmBridge.LICENSE_MANAGER;
    }

    protected double nativeCompareCode(byte[] code1, byte[] code2) {
        return CasAndroidArmBridge.FFSimilarityByte(code1, code2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nativeDetectFace(byte[] imgMatrix, int width, int height, List<CodeInfo> faceInfo) {
        double[] buffer = faceBuffer.get();
        CasAndroidArmBridge instance = FaceApiCasAndroid.applyInstance();
        try {
            int res = instance.detect(imgMatrix, width, height, buffer);
            for (int i = 0; i < res; ++i) {
                faceInfo.add(new NativeFaceInfo(buffer, i * 61));
            }
        }
        finally {
            FaceApiCasAndroid.returnInstance(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] nativeGetFaceFeature(byte[] imgMatrix, int width, int height, CodeInfo faceInfo) {
        NativeFaceInfo nativeFaceInfo = NativeFaceInfo.toNative(faceInfo);
        CasAndroidArmBridge instance = FaceApiCasAndroid.applyInstance();
        try {
            byte[] byArray = instance.feaExtractByte(imgMatrix, width, height, nativeFaceInfo.nativeData);
            return byArray;
        }
        finally {
            FaceApiCasAndroid.returnInstance(instance);
        }
    }

    public List<CodeInfo> detectFace(Bitmap bitmap) {
        try {
            return this.detectFace((BaseLazyImage)LazyImage.create((Bitmap)bitmap));
        }
        catch (ImageErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public List<CodeInfo> getCodeInfo(Bitmap bitmap, int faceNum, List<CodeInfo> facePos) throws NotFaceDetectedException {
        return this.getCodeInfo((BaseLazyImage)LazyImage.create((Bitmap)bitmap), faceNum, facePos);
    }

    public CodeInfo getCodeInfo(Bitmap bitmap, CodeInfo facePos) {
        return this.getCodeInfo((BaseLazyImage)LazyImage.create((Bitmap)bitmap), facePos);
    }

    public CodeInfo[] detectAndGetCodeInfo(Bitmap bitmap, int faceNum) throws NotFaceDetectedException {
        try {
            return this.detectAndGetCodeInfo((BaseLazyImage)LazyImage.create((Bitmap)bitmap).open(), faceNum);
        }
        catch (ImageErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public FeatureSe getFeatureSe() {
        return FseAndroidBridge.getFeatureSe();
    }

    private static CasAndroidArmBridge applyInstance() throws SdkRuntimeException {
        try {
            return (CasAndroidArmBridge)pool.borrowObject();
        }
        catch (SdkInitException e) {
            throw new SdkRuntimeException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void returnInstance(CasAndroidArmBridge obj) {
        pool.returnObject((Object)obj);
    }

    static {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setJmxEnabled(false);
        pool = new GenericObjectPool((PooledObjectFactory)new BridgeInstanceFactory(), config);
        int concurrenty = CasAndroidArmBridge.CONFIG.getConcurrency();
        if (concurrenty > 0) {
            concurrentLock = new ShareLock(concurrenty);
        }
    }
}

