/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.cassdk;

import net.gdface.sdk.CodeInfo;
import net.gdface.sdk.EyeInfo;
import net.gdface.sdk.FAngle;
import net.gdface.sdk.FInt2;
import net.gdface.sdk.FRect;
import net.gdface.utils.Assert;
import net.gdface.utils.BufferUtils;

public class NativeFaceInfo
extends CodeInfo {
    private static final long serialVersionUID = 1L;
    double quality;
    int clarity;
    int brightness;
    double confidence;
    double[] nativeData;

    public NativeFaceInfo(double[] nativeData) {
        this(nativeData, 0);
    }

    public NativeFaceInfo(double[] nativeData, int start) {
        this.init(nativeData, start);
    }

    public NativeFaceInfo(CodeInfo codeInfo) {
        Assert.notNull((Object)codeInfo, (String)"codeinfo");
        byte[] facialData = codeInfo.getFacialData();
        Assert.notNull((Object)facialData, (String)"facialData");
        this.init(BufferUtils.asDoubleArray((byte[])facialData), 0);
    }

    private void init(double[] nativeData, int start) {
        Assert.isTrue((start >= 0 ? 1 : 0) != 0, (String)"start>=0", (String)"invalid start");
        Assert.isTrue((nativeData != null && nativeData.length - start >= 61 ? 1 : 0) != 0, (String)"nativeData!=null && nativeData.length-start>=CaffeMobile.FDDATA_LEN", (String)"invalid nativeData");
        this.nativeData = new double[61];
        System.arraycopy(nativeData, start, this.nativeData, 0, this.nativeData.length);
        FRect pos = this.getPos();
        if (pos == null) {
            pos = new FRect();
        }
        pos.setLeft((int)this.nativeData[FieldIndex.FRECT_LEFT.ordinal()]);
        pos.setTop((int)this.nativeData[FieldIndex.FRECT_TOP.ordinal()]);
        pos.setWidth((int)this.nativeData[FieldIndex.FRECT_WIDTH.ordinal()]);
        pos.setHeight((int)this.nativeData[FieldIndex.FRECT_HEIGHT.ordinal()]);
        this.setPos(pos);
        FAngle angle = this.getAngle();
        if (angle == null) {
            angle = new FAngle();
        }
        angle.setRoll((int)this.nativeData[FieldIndex.FANGLE_ROLL.ordinal()]);
        angle.setYaw((int)this.nativeData[FieldIndex.FANGLE_YAW.ordinal()]);
        angle.setPitch((int)this.nativeData[FieldIndex.FANGLE_PITCH.ordinal()]);
        angle.setConfidence((float)((int)(this.nativeData[FieldIndex.FD_CONFIDENCE.ordinal()] * 100.0)));
        this.setAngle(angle);
        EyeInfo ei = this.getEi();
        if (ei == null) {
            ei = new EyeInfo();
        }
        double lx = (this.nativeData[FieldIndex.FD_POINT0_X.ordinal()] + this.nativeData[FieldIndex.FD_POINT16_X.ordinal()] + this.nativeData[FieldIndex.FD_POINT17_X.ordinal()] + this.nativeData[FieldIndex.FD_POINT18_X.ordinal()]) / 4.0;
        double ly = (this.nativeData[FieldIndex.FD_POINT0_Y.ordinal()] + this.nativeData[FieldIndex.FD_POINT16_Y.ordinal()] + this.nativeData[FieldIndex.FD_POINT17_Y.ordinal()] + this.nativeData[FieldIndex.FD_POINT18_Y.ordinal()]) / 4.0;
        double rx = (this.nativeData[FieldIndex.FD_POINT1_X.ordinal()] + this.nativeData[FieldIndex.FD_POINT19_X.ordinal()] + this.nativeData[FieldIndex.FD_POINT20_X.ordinal()] + this.nativeData[FieldIndex.FD_POINT21_X.ordinal()]) / 4.0;
        double ry = (this.nativeData[FieldIndex.FD_POINT1_Y.ordinal()] + this.nativeData[FieldIndex.FD_POINT19_Y.ordinal()] + this.nativeData[FieldIndex.FD_POINT20_Y.ordinal()] + this.nativeData[FieldIndex.FD_POINT21_Y.ordinal()]) / 4.0;
        ei.setLeftx((int)lx);
        ei.setLefty((int)ly);
        ei.setRightx((int)rx);
        ei.setRighty((int)ry);
        this.setEi(ei);
        FInt2 mouth = this.getMouth();
        if (mouth == null) {
            mouth = new FInt2();
        }
        mouth.setX((int)this.nativeData[FieldIndex.FD_POINT14_X.ordinal()]);
        mouth.setY((int)this.nativeData[FieldIndex.FD_POINT14_Y.ordinal()]);
        this.setMouth(mouth);
        FInt2 nose = this.getNose();
        if (nose == null) {
            nose = new FInt2();
        }
        nose.setX((int)this.nativeData[FieldIndex.FD_POINT7_X.ordinal()]);
        nose.setY((int)this.nativeData[FieldIndex.FD_POINT7_Y.ordinal()]);
        this.setNose(nose);
        this.quality = this.nativeData[FieldIndex.FD_QUALITY.ordinal()];
        this.clarity = (int)this.nativeData[FieldIndex.FD_CLARITY.ordinal()];
        this.brightness = (int)this.nativeData[FieldIndex.FD_BRIGHTNESS.ordinal()];
        this.confidence = this.nativeData[FieldIndex.FD_CONFIDENCE.ordinal()];
        this.setFacialData(BufferUtils.asByteArray((double[])this.nativeData));
    }

    public static NativeFaceInfo toNative(CodeInfo code) {
        if (code == null) {
            return null;
        }
        if (code instanceof NativeFaceInfo) {
            return (NativeFaceInfo)code;
        }
        return new NativeFaceInfo(code);
    }

    public double getQuality() {
        return this.quality;
    }

    public int getClarity() {
        return this.clarity;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double[] getNativeData() {
        return this.nativeData;
    }

    static enum FieldIndex {
        FRECT_LEFT,
        FRECT_TOP,
        FRECT_WIDTH,
        FRECT_HEIGHT,
        FD_QUALITY,
        FANGLE_ROLL,
        FANGLE_YAW,
        FANGLE_PITCH,
        FD_CLARITY,
        FD_BRIGHTNESS,
        FD_POINT0_X,
        FD_POINT0_Y,
        FD_POINT1_X,
        FD_POINT1_Y,
        FD_POINT2_X,
        FD_POINT2_Y,
        FD_POINT3_X,
        FD_POINT3_Y,
        FD_POINT4_X,
        FD_POINT4_Y,
        FD_POINT5_X,
        FD_POINT5_Y,
        FD_POINT6_X,
        FD_POINT6_Y,
        FD_POINT7_X,
        FD_POINT7_Y,
        FD_POINT8_X,
        FD_POINT8_Y,
        FD_POINT9_X,
        FD_POINT9_Y,
        FD_POINT10_X,
        FD_POINT10_Y,
        FD_POINT11_X,
        FD_POINT11_Y,
        FD_POINT12_X,
        FD_POINT12_Y,
        FD_POINT13_X,
        FD_POINT13_Y,
        FD_POINT14_X,
        FD_POINT14_Y,
        FD_POINT15_X,
        FD_POINT15_Y,
        FD_POINT16_X,
        FD_POINT16_Y,
        FD_POINT17_X,
        FD_POINT17_Y,
        FD_POINT18_X,
        FD_POINT18_Y,
        FD_POINT19_X,
        FD_POINT19_Y,
        FD_POINT20_X,
        FD_POINT20_Y,
        FD_POINT21_X,
        FD_POINT21_Y,
        FD_POINT22_X,
        FD_POINT22_Y,
        FD_POINT23_X,
        FD_POINT23_Y,
        FD_POINT24_X,
        FD_POINT24_Y,
        FD_CONFIDENCE;

    }
}

