package net.gdface.cassdk;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

/**
 * 创建{@link CasAndroidArmBridge}实例的工厂类,用于commons-pool2资源池的实例管理
 * @author guyadong
 *
 */
class BridgeInstanceFactory implements PooledObjectFactory<CasAndroidArmBridge> {
	BridgeInstanceFactory() {
	}

	@Override
	public PooledObject<CasAndroidArmBridge> makeObject() throws Exception {
		return new DefaultPooledObject<>(new CasAndroidArmBridge().init());
	}

	@Override
	public void destroyObject(PooledObject<CasAndroidArmBridge> p) throws Exception {
		p.getObject().destroy();
	}

	@Override
	public boolean validateObject(PooledObject<CasAndroidArmBridge> p) {
		// 初始化成功的实例为有效实例
		return p.getObject().getStatus() == SdkStatus.SDK_INIT_OK;
	}

	@Override
	public void activateObject(PooledObject<CasAndroidArmBridge> p) throws Exception {
		// DO NOTHING
	}

	@Override
	public void passivateObject(PooledObject<CasAndroidArmBridge> p) throws Exception {
		// DO NOTHING
	}

}