package net.gdface.cassdk;

/**
 * CASSDK android/arm平台参数配置接口<br>
 * SDK初始化时以SPI(Service Provider Interface)机制加载应用层提供的
 * {@link CasAndroidConfigProvider}实例,并通过接口实例获取的参数初始化SDK<br>
 * 参见 {@link CasAndroidArmBridge}的{@code config}字段.<br>
 * NOTE:一般情况下无需修改SDK初始化参数.
 * @author guyadong
 *
 */
public interface CasAndroidConfigProvider {
    /**
	 * 人脸检测数据的(double)数组长度
	 */
	public static final int FDDATA_LEN = 61;
	/**
	 * 人脸检测数据的(byte)数组长度
	 */
	public static final int FDDATA_BYTES=FDDATA_LEN*(Double.SIZE/8);
	/**
	 * 最大检测人脸数目
	 */
	public static final int MAX_FACE_COUNT = 32;
	/**
	 * 人脸特征数据数组(double[])长度
	 */
	public static final int FEATURE_LEN = 512;
	/**
	 * 人脸特征数据数组(byte[])长度
	 */
	public static final int FEATURE_BYTES=FEATURE_LEN*(Double.SIZE/8);
	/**
	 * 默认短边缩放尺寸
	 */
	public static final int DEFAULT_PROCESSMINL = 360;
	/**
	 * 默认长边缩放尺寸
	 */
	public static final int DEFAULT_PROCESSMAXL = 640;
	/**
	 * 默认检测阈值
	 */
	public static final double DEFAULT_DETECT_THRESHOLD=0.7;
	
	/**
	 * 返回最大检测的人脸数
	 * @return 
	 */
	int getMaxFaceCount();
	/**
	 * 返回人脸检测图像短边缩放尺寸
	 * @return
	 */
	int getProcessMinl();
	/**
	 * 返回人脸检测图像长边缩放尺寸
	 * @return
	 */
	int getProcessMaxl();
	/**
	 * 返回人脸检测模块检测阈值 
	 * @return
	 */
	double getDetectThreshold();
	/**
	 * 指定最大调用并发线程数,返回0使用默认值(CPU核数)
	 * @return
	 */
	int getConcurrency();
}
