package net.gdface.cassdk;

import net.gdface.license.BaseLicenseManager;
import net.gdface.license.RegStatus;
import net.gdface.license.RegisterException;
import net.gdface.utils.Judge;

import static net.gdface.cassdk.CasAndroidArmBridge.*;

/**
 * CASSDK android/arm 授权信息管理对象 
 * @author guyadong
 *
 */
public class CasLicenseManager extends BaseLicenseManager {
	public CasLicenseManager() {
	}
	@Override
	public boolean validateLicense(String licenseKey, String licenseCode) {
		if(!Judge.isEmpty(licenseKey) && !Judge.isEmpty(licenseCode)){
			CasAndroidArmBridge tmp = new CasAndroidArmBridge();
			SdkStatus fdSdkStatus = fdInit(licenseKey,licenseCode,tmp);
			if(fdSdkStatus == SdkStatus.SDK_INIT_OK){
				FDDestroy(tmp.detectHandle[0]);
				return true;
			}
		}
		return false;
	}

	@Override
	public String getDevicesSerial(String licenseKey) throws RegisterException {
		byte[] buffer = new byte[128];
		// 输出缓冲区清0
		for (int i = 0; i < buffer.length; i++) {
		    buffer[i] = 0;
		}
		int res = FSGetDevicesSerial(buffer, licenseKey.getBytes());
		
		if (res > 0) {
			return new String(buffer, 0, res);
		} 
		throw new RegisterException(RegStatus.REG_FAIL_TO_GET_DEVICE_SERIAL);
	}

}
