package net.gdface.cassdk;

/**
 * SDK初始化状态
 * @author guyadong
 *
 */
public enum SdkStatus {
	SDK_UNINITIALIZED("sdk uninitialized(未初始化)"),
	SDK_INIT_OK(0,"init ok(初始化成功)"),
	SDK_INVALID_ARG(-51,"invalid argument(参数为空)"),
	SDK_NOT_FOUND_FILE(-52,"not found file(文件找不到)"),
	SDK_NOT_EXIST_FILE(-53,"not exist file(文件不存在)"),
	SDK_NOT_FOUND_RECON_MODEL(-60,"not found model file(识别模型文件找不到)"),
	SDK_FAIL_LOAD_RECON_MODEL(-61,"fail to load model file(人脸识别模型加载失败)"),
	SDK_FAIL_INIT_RECON_MODULE(-62,"fail to init recon module(识别模块初始化失败)"),
	SDK_FAIL_INIT_DETECT_MODULE(-63,"fail to init detect module(人脸检测模块初始化失败)"),
	SDK_NULL_HANDLE(-64,"null handle(句柄为空)"),
	SDK_IMG_ARG_ERROR(-65,"null handle(图像参数错误)"),
	SDK_AUTHOR_ERROR (-66,"AUTHOR ERROR"),
	SDK_UNREGISTERED_DEVICE(-67,"unregistered device(设备未注册，请联系管理员)"),
	SDK_COMMUNICATION_ERROR(-68,"communication error(通讯异常)"),
	SDK_SN_ERROR(-401,"serial number error(获取系列号失败)"),
	SDK_LICENSE_DECRYPT_ERROR(-402,"unlocal license decode error(非本地授权文件中的授权码解码失败)"),
	SDK_TIMEOUT(-403,"time out(适用时间限制)"),
	SDK_LOCAL_LICENSE_DECRYPT_ERROR(-404,"local license decode error(本地授权文件中的授权码解码失败)"),
	SDK_NO_EXIST_LOCAL_LICENSE(-405,"not exist local license(本地授权文件不存在或者为空或者无权限)"),
	SDK_FAIL_LICENSE_COMPARE(-406,"fail to compare license(授权码与当前设备信息不吻合)"),
	SDK_FAIL_GET_MAC(-407,"fail to compare license(获取不到MAC地址)"),
	SDK_UNINITIZLIED_CHANNEL(-501,"uninitizlied channel(当前通道未初始化)"),
	SDK_INPUT_DATA_ERROR(-502,"input data error(输入数据不正确)"),
	LICENSE_ERROR("License error(在线授权异常)"),
	UNKNOW_ERROR("Unknown result(未知错误)"),
	OTHER_EXCEPTION("Exception");
	/** 状态描述信息 */
	final String msg;
	/** 状态码 */
	final int error;
	private SdkStatus(String msg){
		this(-1, msg);
	}
	private SdkStatus(int error,String msg){
		this.error = error;
		this.msg = msg;		
	}
	/**
	 * 根据SDK jni调用返回的状态码返回{@link SdkStatus}实例
	 * @param code
	 * @return
	 */
	static SdkStatus jniCode(int code){
		switch(code){
		case 0 :
			return SDK_INIT_OK;
		case -51:
			return SDK_INVALID_ARG;
		case -52:
			return SDK_NOT_FOUND_FILE;
		case -53:
			return SDK_NOT_EXIST_FILE;
		case -60:
			return SDK_NOT_FOUND_RECON_MODEL;
		case -61:
			return SDK_FAIL_LOAD_RECON_MODEL;
		case -62:
			return SDK_FAIL_INIT_RECON_MODULE;
		case -63:
			return SDK_FAIL_INIT_DETECT_MODULE;
		case -64:
			return SDK_NULL_HANDLE;
		case -65:
			return SDK_IMG_ARG_ERROR;
		case -66:
			return SDK_AUTHOR_ERROR;
		case -67:
			return SDK_UNREGISTERED_DEVICE;
		case -68:
			return SDK_COMMUNICATION_ERROR;
		case -401:
			return SDK_SN_ERROR;
		case -402:
			return SDK_LICENSE_DECRYPT_ERROR;
		case -403:
			return SDK_TIMEOUT;
		case -404:
			return SDK_LOCAL_LICENSE_DECRYPT_ERROR;
		case -405:
			return SDK_NO_EXIST_LOCAL_LICENSE;
		case -406:
			return SDK_FAIL_LICENSE_COMPARE;
		case -407:
			return SDK_FAIL_GET_MAC;
		case -501:
			return SDK_UNINITIZLIED_CHANNEL;
		case -502:
			return SDK_INPUT_DATA_ERROR;
		default:
			return UNKNOW_ERROR;
		}
	}
}
