/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.cassdk;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import net.gdface.cassdk.JniBridge;
import net.gdface.cassdk.jna.FaceAngle;
import net.gdface.cassdk.jna.THFI_FacePos;
import net.gdface.cassdk.jna.tagPOINT;
import net.gdface.cassdk.jna.tagRECT;
import net.gdface.image.ImageErrorException;
import net.gdface.image.LazyImage;
import net.gdface.image.UnsupportedFormatException;
import net.gdface.sdk.BaseFaceApiLocal;
import net.gdface.sdk.CodeInfo;
import net.gdface.sdk.EyeInfo;
import net.gdface.sdk.FAngle;
import net.gdface.sdk.FInt2;
import net.gdface.sdk.FRect;
import net.gdface.sdk.NotFaceDetectedException;
import net.gdface.sdk.RectUtils;
import net.gdface.utils.Assert;
import net.gdface.utils.FaceUtilitsX;

public class FaceApiCasWrapper
extends BaseFaceApiLocal {
    private static final Logger logger = Logger.getLogger(FaceApiCasWrapper.class.getSimpleName());
    private static final FaceApiCasWrapper INSTANCE = new FaceApiCasWrapper();

    private FaceApiCasWrapper() {
    }

    public static FaceApiCasWrapper getInstance() {
        return INSTANCE;
    }

    protected double doCompareCode(byte[] code1, byte[] code2) {
        return JniBridge.compareFeature(code1, code2);
    }

    private static FRect makeFRect(tagRECT rect) {
        return null == rect ? null : new FRect(rect.left, rect.top, rect.right - rect.left + 1, rect.bottom - rect.top + 1);
    }

    private static final tagRECT toNative(FRect rect) {
        return null == rect ? null : new tagRECT(rect.getLeft(), rect.getTop(), rect.getLeft() + rect.getWidth() - 1, rect.getTop() + rect.getHeight() - 1);
    }

    private static final EyeInfo makeEyeInfo(tagPOINT leftEye, tagPOINT rightEye) {
        return null == leftEye || null == rightEye || 0 == leftEye.x && 0 == leftEye.y && 0 == rightEye.x && 0 == rightEye.y ? null : new EyeInfo(leftEye.x, leftEye.y, rightEye.x, rightEye.y);
    }

    private static final tagPOINT toNativeLeft(EyeInfo ei) {
        return null == ei || 0 == ei.getLeftx() && 0 == ei.getLefty() ? null : new tagPOINT(ei.getLeftx(), ei.getLefty());
    }

    private static final tagPOINT toNativeRight(EyeInfo ei) {
        return null == ei || 0 == ei.getRightx() && 0 == ei.getRighty() ? null : new tagPOINT(ei.getRightx(), ei.getRighty());
    }

    private static final FInt2 makeFInt2(tagPOINT point) {
        return null == point || 0 == point.x && 0 == point.y ? null : new FInt2(point.x, point.y);
    }

    private static final tagPOINT toNative(FInt2 point) {
        return null == point || 0 == point.getX() && 0 == point.getY() ? null : new tagPOINT(point.getX(), point.getY());
    }

    private static final FAngle makeFAngle(FaceAngle angle) {
        return null == angle || 0 == angle.yaw && 0 == angle.pitch && 0 == angle.roll ? null : new FAngle(angle.yaw, angle.pitch, angle.roll, angle.confidence);
    }

    private static final FaceAngle toNative(FAngle angle) {
        return null == angle || 0 == angle.getYaw() && 0 == angle.getPitch() && 0 == angle.getRoll() ? null : new FaceAngle(angle.getYaw(), angle.getPitch(), angle.getRoll(), angle.getConfidence());
    }

    private static final CodeInfo makeCodeInfo(THFI_FacePos ci) {
        return null == ci ? null : new CodeInfo(null, FaceApiCasWrapper.makeFRect(ci.rcFace), FaceApiCasWrapper.makeEyeInfo(ci.ptLeftEye, ci.ptRightEye), FaceApiCasWrapper.makeFInt2(ci.ptMouth), FaceApiCasWrapper.makeFInt2(ci.ptNose), FaceApiCasWrapper.makeFAngle(ci.fAngle), ci.pFacialData);
    }

    private static final THFI_FacePos toNative(CodeInfo pos) {
        return null == pos ? null : new THFI_FacePos(FaceApiCasWrapper.toNative(pos.getPos()), FaceApiCasWrapper.toNativeLeft(pos.getEi()), FaceApiCasWrapper.toNativeRight(pos.getEi()), FaceApiCasWrapper.toNative(pos.getMouth()), FaceApiCasWrapper.toNative(pos.getNose()), FaceApiCasWrapper.toNative(pos.getAngle()), 0, pos.getFacialData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CodeInfo> detectFace(LazyImage lazyImg, FRect detectRectangle) throws UnsupportedFormatException {
        concurrentLock.lock();
        try {
            Rectangle dr;
            Assert.notNull((Object)lazyImg, (String)"bufImg");
            Rectangle imgRect = lazyImg.getRectangle();
            if (null == detectRectangle) {
                dr = imgRect;
            } else {
                dr = RectUtils.newRectangle((FRect)detectRectangle);
                RectUtils.assertContains((Rectangle)imgRect, (String)"imgRect", (Rectangle)dr, (String)"detectRectangle");
            }
            ArrayList<CodeInfo> faceInfo = new ArrayList<CodeInfo>();
            if (dr.width > 0 && dr.height > 0) {
                THFI_FacePos[] posArray;
                byte[] imgRGB = this.getMatrixData(lazyImg, RectUtils.newFRect((Rectangle)dr));
                for (THFI_FacePos pos : posArray = JniBridge.detectFace(imgRGB, 24, dr.width, dr.height)) {
                    faceInfo.add(FaceApiCasWrapper.makeCodeInfo(pos));
                }
                if (!RectUtils.isZeroPoint((Rectangle)dr)) {
                    for (CodeInfo ci : faceInfo) {
                        RectUtils.translate((CodeInfo)ci, (int)dr.x, (int)dr.y);
                    }
                }
            }
            ArrayList<CodeInfo> arrayList = faceInfo;
            return arrayList;
        }
        finally {
            concurrentLock.unlock();
        }
    }

    protected final CodeInfo getCodeFromImageMatrix(byte[] imgMatrix, int width, int height, CodeInfo faceInfo, AtomicBoolean hasFail) {
        Assert.notEmpty((byte[])imgMatrix, (String)"imgMatrix");
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException(String.format("INVALID VALUE:the imgMatrix's size(%dW%dH) ", width, height));
        }
        Assert.notNull((Object)faceInfo, (String)"faceInfo");
        byte[] code = JniBridge.getFaceFeature(imgMatrix, width, height, FaceApiCasWrapper.toNative(faceInfo));
        if (null == code && null != hasFail) {
            hasFail.set(true);
        }
        faceInfo.setCode(code);
        return faceInfo;
    }

    protected byte[] getMatrixData(LazyImage lazyImg, FRect rect) throws UnsupportedFormatException {
        return lazyImg.getMatrixBGR(null == rect ? null : RectUtils.newRectangle((FRect)rect));
    }

    public List<CodeInfo> getCodeInfo(LazyImage lazyImg, int faceNum, List<CodeInfo> facePos) throws NotFaceDetectedException {
        concurrentLock.lock();
        int faceCount = 0;
        int featureCount = 0;
        AtomicBoolean hasFail = new AtomicBoolean(false);
        try {
            int i;
            Assert.notNull((Object)lazyImg, (String)"lazyImg");
            Assert.notEmpty(facePos, (String)"facePos");
            if (facePos.size() < faceNum) {
                throw new NotFaceDetectedException(facePos.size(), 0);
            }
            byte[] imgData = this.getMatrixData(lazyImg, null);
            THFI_FacePos[] nativeArray = new THFI_FacePos[facePos.size()];
            for (int i2 = 0; i2 < nativeArray.length; ++i2) {
                nativeArray[i2] = FaceApiCasWrapper.toNative(facePos.get(i2));
            }
            byte[][] features = JniBridge.getFaceFeatures(imgData, lazyImg.getWidth(), lazyImg.getHeight(), nativeArray);
            for (i = 0; i < features.length; ++i) {
                if (null == nativeArray[i]) continue;
                ++faceCount;
                if (null == features[i]) continue;
                ++featureCount;
            }
            if (faceNum > 0) {
                if (featureCount != faceNum) {
                    throw new NotFaceDetectedException(faceCount, featureCount);
                }
            } else if (0 == featureCount) {
                throw new NotFaceDetectedException(faceCount, 0);
            }
            for (i = 0; i < nativeArray.length; ++i) {
                CodeInfo ci = facePos.get(i);
                if (null == ci) continue;
                ci.setCode(features[i]);
            }
            List<CodeInfo> list = facePos;
            return list;
        }
        catch (UnsupportedFormatException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (featureCount != faceCount) {
                hasFail.set(true);
            }
            this.saveFail(hasFail.get(), lazyImg);
            concurrentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeInfo[] detectAndGetCodeInfo(LazyImage lazyImg, int faceNum, FRect detectRectangle) throws ImageErrorException, NotFaceDetectedException {
        concurrentLock.lock();
        try {
            byte[] imgData = this.getMatrixData(lazyImg, detectRectangle);
            LinkedHashMap<THFI_FacePos, byte[]> facePos = JniBridge.detectAndGetFeatures(imgData, lazyImg.getWidth(), lazyImg.getHeight());
            if (0 == facePos.size()) {
                throw this.NOTFACEDETECTED_INSTANCE_DEFAULT;
            }
            if (faceNum > 0 && faceNum != facePos.size()) {
                throw this.NOTFACEDETECTED_INSTANCE_DEFAULT;
            }
            CodeInfo[] ci = new CodeInfo[facePos.size()];
            int i = 0;
            CodeInfo element = null;
            for (Map.Entry<THFI_FacePos, byte[]> entry : facePos.entrySet()) {
                element = FaceApiCasWrapper.makeCodeInfo(entry.getKey());
                element.setCode(entry.getValue());
                ci[i++] = element;
            }
            CodeInfo[] codeInfoArray = ci;
            return codeInfoArray;
        }
        finally {
            concurrentLock.unlock();
        }
    }

    static {
        if (!FaceUtilitsX.isBuilding()) {
            try {
                Class.forName(JniBridge.class.getName());
            }
            catch (ClassNotFoundException e) {
                logger.severe(e.getMessage());
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

