/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.cassdk;

import com.sun.jna.NativeLibrary;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import net.gdface.cassdk.BaseJniBridge;
import net.gdface.cassdk.CasConfig;
import net.gdface.cassdk.JniException;
import net.gdface.cassdk.jna.FSFaceSDKLibrary;
import net.gdface.cassdk.jna.THFI_FacePos;
import net.gdface.utils.ResourcePool;

public class JniBridge
extends BaseJniBridge {
    protected static final FSFaceSDKLibrary fsfacesdkLibrary;
    private static final String licenseCode;

    private static void init() throws ExceptionInInitializerError {
        logger.info(String.format("CASSDK %s initializing(SDK\u6b63\u5728\u521d\u59cb\u5316)", CasConfig.getVersion().version));
        logger.info(String.format("model initializing(\u6a21\u578b\u6570\u636e\u521d\u59cb\u5316) MODE:%s", CasConfig.isGpuMode() ? "GPU ID:" + CasConfig.getDeviceID() : "CPU"));
        int featureChannelNum = CasConfig.getFeatureChannelNum();
        int detectChannelNum = CasConfig.getFeatureChannelNum();
        try {
            JniBridge.copyModelToUserDir();
            logger.info(String.format("\u4eba\u8138\u68c0\u6d4b\u901a\u9053: %d", detectChannelNum));
            logger.info(String.format("\u7279\u5f81\u63d0\u53d6\u901a\u9053: %d", featureChannelNum));
            detectChannelPool = new ResourcePool.IntResourcePool(detectChannelNum);
            featureChannelPool = new ResourcePool.IntResourcePool(featureChannelNum);
            logger.info("detect module initializing(\u4eba\u8138\u68c0\u6d4b\u6a21\u5757\u521d\u59cb\u5316)");
            logger.info("feature module initializing(\u7279\u5f81\u63d0\u53d6\u6a21\u5757\u521d\u59cb\u5316)");
            int result = fsfacesdkLibrary.FSInit((short)detectChannelNum, null == licenseCode ? null : ByteBuffer.wrap(licenseCode.getBytes()));
            if (result <= 0) {
                StringBuffer buffer = new StringBuffer("fail to initTHFeature,error code:");
                buffer.append(result);
                switch (result) {
                    case -1: {
                        buffer.append("msg:").append("open file \"feadb.db*\" error");
                        break;
                    }
                    case -2: {
                        buffer.append("msg:").append("check  file \"feadb.db*\" error");
                        break;
                    }
                    case -3: {
                        buffer.append("msg:").append("read  file \"feadb.db*\" error");
                        break;
                    }
                    default: {
                        if (result > -90) break;
                        buffer.append("msg:").append("invalid license");
                    }
                }
                throw new JniException(buffer.toString());
            }
        }
        catch (Exception e) {
            logger.info(String.format("%s:%s", e.getClass().getSimpleName(), e.getMessage()));
            throw new ExceptionInInitializerError(e);
        }
        logger.info("CASSDK initialized(SDK\u521d\u59cb\u5316\u7ed3\u675f)");
    }

    private static void release() {
        fsfacesdkLibrary.FSRelease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static THFI_FacePos[] detectFace(byte[] imgData, int bpp, int width, int height) {
        if (null == imgData) {
            throw new NullPointerException("imgData must not be null");
        }
        if (bpp != 24) {
            throw new IllegalArgumentException("must RGB24");
        }
        if (imgData.length != width * height * 3) {
            throw new NullPointerException("INVALID imageData");
        }
        short nChannelID = ((Integer)detectChannelPool.apply()).shortValue();
        THFI_FacePos[] pfps = new THFI_FacePos[maxDetectFaceNum];
        try {
            int result = fsfacesdkLibrary.FSDetectFace(nChannelID, ByteBuffer.wrap(imgData), bpp, width, height, pfps, pfps.length, sampleSize);
            if (result < 0) {
                StringBuffer buffer = new StringBuffer("fail to THFI_DetectFace,error code:");
                buffer.append(result);
                switch (result) {
                    case -1: {
                        buffer.append("msg:").append("nChannelID is invalid or SDK is not initialized");
                        break;
                    }
                    case -2: {
                        buffer.append("msg:").append("image data is invalid,please check function parameter:pImage,bpp,nWidth,nHeight");
                        break;
                    }
                    case -3: {
                        buffer.append("msg:").append("pfps or nMaxFaceNums is invalid");
                        break;
                    }
                    default: {
                        if (result > -90) break;
                        buffer.append("msg:").append("invalid license");
                    }
                }
                throw new JniException(buffer.toString());
            }
            THFI_FacePos[] tHFI_FacePosArray = Arrays.copyOf(pfps, result);
            return tHFI_FacePosArray;
        }
        finally {
            detectChannelPool.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFaceFeature(byte[] imgData, int width, int height, THFI_FacePos facePos) {
        if (null == imgData) {
            throw new NullPointerException("imgData must not be null");
        }
        if (imgData.length != width * height * 3) {
            throw new NullPointerException("INVALID imageData");
        }
        short nChannelID = ((Integer)featureChannelPool.apply()).shortValue();
        ByteBuffer featureBuffer = ByteBuffer.allocate(FEATURE_SIZE);
        try {
            int result = fsfacesdkLibrary.FSExtract(nChannelID, ByteBuffer.wrap(imgData), width, height, 3, facePos, featureBuffer);
            if (result < 0) {
                StringBuffer buffer = new StringBuffer("fail to EF_Extract,error code:");
                buffer.append(result);
                switch (result) {
                    case -1: {
                        buffer.append("msg:").append("pBuf,ptfp,pFeature is NULL");
                        break;
                    }
                    case -2: {
                        buffer.append("msg:").append("nChannelID is invalid or SDK is not initialized");
                        break;
                    }
                    default: {
                        if (result > -90) break;
                        buffer.append("msg:").append("invalid license");
                    }
                }
                throw new JniException(buffer.toString());
            }
            byte[] byArray = featureBuffer.array();
            return byArray;
        }
        finally {
            featureChannelPool.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[][] getFaceFeatures(byte[] imgData, int width, int height, THFI_FacePos[] facePosArray) {
        if (null == imgData) {
            throw new NullPointerException("imgData must not be null");
        }
        if (null == facePosArray) {
            throw new NullPointerException("facePosArray must not be null");
        }
        if (imgData.length != width * height * 3) {
            throw new NullPointerException("INVALID imageData");
        }
        short nChannelID = ((Integer)featureChannelPool.apply()).shortValue();
        ByteBuffer featuresBuffer = ByteBuffer.allocate(FEATURE_SIZE * facePosArray.length);
        try {
            int result = fsfacesdkLibrary.FSExtract_M(nChannelID, ByteBuffer.wrap(imgData), width, height, 3, facePosArray, featuresBuffer, facePosArray.length);
            if (result < 0) {
                StringBuffer buffer = new StringBuffer("fail to EF_Extract,error code:");
                buffer.append(result);
                switch (result) {
                    case -99: {
                        buffer.append("msg:").append("invalid license");
                        break;
                    }
                    case -1: {
                        buffer.append("msg:").append("pBuf,ptfp,pFeature is NULL");
                        break;
                    }
                    case -2: {
                        buffer.append("msg:").append("nChannelID is invalid or SDK is not initialized");
                        break;
                    }
                }
                throw new JniException(buffer.toString());
            }
            byte[][] features = new byte[facePosArray.length][FEATURE_SIZE];
            for (int i = 0; i < facePosArray.length; ++i) {
                features[i] = Arrays.copyOfRange(featuresBuffer.array(), i * FEATURE_SIZE, (i + 1) * FEATURE_SIZE);
            }
            byte[][] byArray = features;
            return byArray;
        }
        finally {
            featureChannelPool.free();
        }
    }

    public static LinkedHashMap<THFI_FacePos, byte[]> detectAndGetFeatures(byte[] imgData, int width, int height) {
        LinkedHashMap<THFI_FacePos, byte[]> map = new LinkedHashMap<THFI_FacePos, byte[]>(16);
        THFI_FacePos[] facepos = JniBridge.detectFace(imgData, 24, width, height);
        byte[][] features = JniBridge.getFaceFeatures(imgData, width, height, facepos);
        for (int i = 0; i < facepos.length; ++i) {
            map.put(facepos[i], features[i]);
        }
        return map;
    }

    public static float compareFeature(byte[] feature1, byte[] feature2) {
        if (null == feature1 || null == feature2) {
            throw new NullPointerException("feature1,feature2 must not be null");
        }
        if (feature1.length != FEATURE_SIZE || feature2.length != FEATURE_SIZE) {
            throw new IllegalArgumentException("INVALID length of feature1 or feature2");
        }
        return fsfacesdkLibrary.FSCompare(ByteBuffer.wrap(feature1), ByteBuffer.wrap(feature2));
    }

    public static String getPollCode() {
        byte[] pollCode = new byte[128];
        int result = fsfacesdkLibrary.FSRegist(ByteBuffer.wrap(pollCode));
        if (result < 0) {
            throw new JniException(String.format("fail to get poll code,error: %d", result));
        }
        return new String(Arrays.copyOf(pollCode, result));
    }

    static {
        String cassdkBin = CASSDK_HOME + "/bin";
        NativeLibrary.addSearchPath((String)"FSFaceSDK", (String)cassdkBin);
        fsfacesdkLibrary = FSFaceSDKLibrary.INSTANCE;
        licenseCode = CasConfig.getLicenseCode();
        if (null == licenseCode) {
            throw new ExceptionInInitializerError(String.format("NOT DEFINED liecnse code for poll code\n %s", JniBridge.getPollCode()));
        }
        FEATURE_SIZE = fsfacesdkLibrary.FSSize();
        logger.info(String.format("FEATURE_SIZE=%d bytes", FEATURE_SIZE));
        JniBridge.init();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BaseJniBridge.logger.info("release cassdk JNI resoure...");
                JniBridge.release();
                System.out.println("release cassdk JNI resoure finished");
            }
        });
    }
}

